"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeComparison = TimeComparison;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_environments_context = require("../../../context/environments_context/use_environments_context");
var _use_anomaly_detection_jobs_context = require("../../../context/anomaly_detection_jobs/use_anomaly_detection_jobs_context");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_time_range = require("../../../hooks/use_time_range");
var urlHelpers = _interopRequireWildcard(require("../links/url_helpers"));
var _get_comparison_options = require("./get_comparison_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/time_comparison/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrependContainer = _styled.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
  background-color: ${({
  theme
}) => theme.euiTheme.colors.backgroundBaseFormsPrepend};
  padding: 0 ${({
  theme
}) => theme.euiTheme.size.m};
`;
function TimeComparison() {
  var _core$application$cap, _comparisonOptions$fi;
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const history = (0, _reactRouterDom.useHistory)();
  const {
    isSmall,
    isMedium
  } = (0, _use_breakpoints.useBreakpoints)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/dependencies/*', '/services/{serviceName}');
  const location = (0, _reactRouterDom.useLocation)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    anomalyDetectionJobsStatus,
    anomalyDetectionJobsData
  } = (0, _use_anomaly_detection_jobs_context.useAnomalyDetectionJobsContext)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    preferredEnvironment
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const canGetJobs = !!((_core$application$cap = core.application.capabilities.ml) !== null && _core$application$cap !== void 0 && _core$application$cap.canGetJobs);
  const comparisonOptions = (0, _react.useMemo)(() => {
    const matchingRoutes = apmRouter.getRoutesToMatch(location.pathname);
    // Only show the "Expected bounds" option in Overview and Transactions tabs
    const showExpectedBoundsForThisTab = !matchingRoutes.some(d => d.path === '/services/{serviceName}/transactions/view') && matchingRoutes.some(d => d.path === '/services/{serviceName}/overview' || d.path === '/services/{serviceName}/transactions');
    const timeComparisonOptions = (0, _get_comparison_options.getComparisonOptions)({
      start,
      end,
      showSelectedBoundsOption: showExpectedBoundsForThisTab && canGetJobs,
      anomalyDetectionJobsStatus,
      anomalyDetectionJobsData,
      preferredEnvironment
    });
    return timeComparisonOptions;
  }, [canGetJobs, anomalyDetectionJobsStatus, anomalyDetectionJobsData, start, end, preferredEnvironment, apmRouter, location.pathname]);
  const isSelectedComparisonTypeAvailable = comparisonOptions.some(({
    value
  }) => value === offset);

  // Replaces type when current one is no longer available in the select options
  if (comparisonOptions.length !== 0 && !isSelectedComparisonTypeAvailable ||
  // If user changes environment and there's no ML jobs that match the new environment
  // then also default to first comparison option as well
  offset === _get_comparison_options.TimeRangeComparisonEnum.ExpectedBounds && ((_comparisonOptions$fi = comparisonOptions.find(d => d.value === _get_comparison_options.TimeRangeComparisonEnum.ExpectedBounds)) === null || _comparisonOptions$fi === void 0 ? void 0 : _comparisonOptions$fi.disabled) === true) {
    urlHelpers.replace(history, {
      query: {
        offset: comparisonOptions[0].value
      }
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.apm.timeComparison.euiSelect.seletTimeComparisonLabel', {
      defaultMessage: 'Select time comparison options'
    }),
    fullWidth: isSmall || isMedium,
    "data-test-subj": "comparisonSelect",
    disabled: comparisonEnabled === false,
    options: comparisonOptions,
    value: offset,
    compressed: true,
    prepend: /*#__PURE__*/_react.default.createElement(PrependContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "comparison",
      label: _i18n.i18n.translate('xpack.apm.timeComparison.label', {
        defaultMessage: 'Comparison'
      }),
      checked: comparisonEnabled,
      onChange: () => {
        const nextComparisonEnabledValue = !comparisonEnabled;
        if (nextComparisonEnabledValue === false) {
          trackApmEvent({
            metric: 'time_comparison_disabled'
          });
        }
        urlHelpers.push(history, {
          query: {
            comparisonEnabled: Boolean(nextComparisonEnabledValue).toString()
          }
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    })),
    onChange: e => {
      trackApmEvent({
        metric: `time_comparison_type_change_${e.target.value}`
      });
      urlHelpers.push(history, {
        query: {
          offset: e.target.value
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
}