"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePagination = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validatePagination = params => {
  var _params$page, _params$per_page;
  const pageAsNumber = (_params$page = params.page) !== null && _params$page !== void 0 ? _params$page : 0;
  const perPageAsNumber = (_params$per_page = params.per_page) !== null && _params$per_page !== void 0 ? _params$per_page : 0;
  if (Math.max(pageAsNumber, pageAsNumber * perPageAsNumber) > 10000) {
    return 'The number of documents is too high. Paginating through more than 10000 documents is not possible.';
  }
};
exports.validatePagination = validatePagination;