"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditorFlyoutContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../constants");
var _confirm_modals = require("./confirm_modals");
var _field_editor = require("./field_editor/field_editor");
var _field_editor_context = require("./field_editor_context");
var _flyout_panels = require("./flyout_panels");
var _preview = require("./preview");
var _state_utils = require("../state_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_editor_flyout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  cancelButtonLabel: _i18n.i18n.translate('indexPatternFieldEditor.editor.flyoutCancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  saveButtonLabel: _i18n.i18n.translate('indexPatternFieldEditor.editor.flyoutSaveButtonLabel', {
    defaultMessage: 'Save'
  }),
  disabledSaveCalloutMessage: _i18n.i18n.translate('indexPatternFieldEditor.editor.flyoutDisabledSaveCalloutMessage', {
    defaultMessage: "You can't edit managed data view fields. Instead, you can duplicate the data view and make changes to your newly created copy."
  })
};
const defaultModalVisibility = {
  confirmChangeNameOrType: false,
  confirmUnsavedChanges: false
};
const isPanelVisibleSelector = state => state.isPanelVisible;
const isSavingSelector = state => state.isSaving;
const FieldEditorFlyoutContentComponent = ({
  fieldToEdit,
  fieldToCreate,
  onSave,
  onCancel,
  onMounted
}) => {
  const isMounted = (0, _react.useRef)(false);
  const isEditingExistingField = !!fieldToEdit;
  const {
    dataView,
    subfields$
  } = (0, _field_editor_context.useFieldEditorContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const {
    controller
  } = (0, _preview.useFieldPreviewContext)();
  const isPanelVisible = (0, _state_utils.useStateSelector)(controller.state$, isPanelVisibleSelector);
  const isSavingField = (0, _state_utils.useStateSelector)(controller.state$, isSavingSelector);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: fieldToEdit ? true : undefined,
    submit: fieldToEdit ? async () => ({
      isValid: true,
      data: fieldToEdit
    }) : async () => ({
      isValid: false,
      data: {}
    })
  });
  const [modalVisibility, setModalVisibility] = (0, _react.useState)(defaultModalVisibility);
  const [isFormModified, setIsFormModified] = (0, _react.useState)(false);
  const {
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const canCloseValidator = (0, _react.useCallback)(() => {
    if (isFormModified) {
      setModalVisibility({
        ...defaultModalVisibility,
        confirmUnsavedChanges: true
      });
    }
    return !isFormModified;
  }, [isFormModified]);
  const onClickSave = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data: updatedField
    } = await submit();
    if (!isMounted.current) {
      // User has closed the flyout meanwhile submitting the form
      return;
    }
    if (isValid) {
      const nameChange = (fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.name) !== updatedField.name;
      const typeChange = (fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.type) !== updatedField.type;
      if (isEditingExistingField && (nameChange || typeChange)) {
        setModalVisibility({
          ...defaultModalVisibility,
          confirmChangeNameOrType: true
        });
      } else {
        if (updatedField.type === 'composite') {
          onSave({
            ...updatedField,
            fields: subfields$.getValue()
          });
        } else {
          onSave(updatedField);
        }
      }
    }
  }, [onSave, submit, fieldToEdit, isEditingExistingField, subfields$]);
  const onClickCancel = (0, _react.useCallback)(() => {
    const canClose = canCloseValidator();
    if (canClose) {
      onCancel();
    }
  }, [onCancel, canCloseValidator]);
  const renderModal = () => {
    if (modalVisibility.confirmChangeNameOrType) {
      return /*#__PURE__*/_react.default.createElement(_confirm_modals.SaveFieldTypeOrNameChangedModal, {
        fieldName: fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.name,
        onConfirm: async () => {
          const {
            data: updatedField
          } = await submit();
          if (updatedField.type === 'composite') {
            onSave({
              ...updatedField,
              fields: subfields$.getValue()
            });
          } else {
            onSave(updatedField);
          }
        },
        onCancel: () => {
          setModalVisibility(defaultModalVisibility);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 9
        }
      });
    }
    if (modalVisibility.confirmUnsavedChanges) {
      return /*#__PURE__*/_react.default.createElement(_confirm_modals.ModifiedFieldModal, {
        onConfirm: () => {
          setModalVisibility(defaultModalVisibility);
          onCancel();
        },
        onCancel: () => {
          setModalVisibility(defaultModalVisibility);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 9
        }
      });
    }
    return null;
  };
  (0, _react.useEffect)(() => {
    if (onMounted) {
      // When the flyout mounts we send to the parent the validator to check
      // if we can close the flyout or not (and display a confirm modal if needed).
      // This is required to display the confirm modal when clicking outside the flyout.
      onMounted({
        canCloseValidator
      });
      return () => {
        onMounted({
          canCloseValidator: () => true
        });
      };
    }
  }, [onMounted, canCloseValidator]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Group, {
    flyoutClassName: _constants.euiFlyoutClassname,
    maxWidth: isMobile ? false : 1180,
    "data-test-subj": "fieldEditor",
    fixedPanelWidths: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    width: 600,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Content, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Header, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 17
    }
  }, fieldToEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.flyoutEditFieldTitle",
    defaultMessage: "Edit field ''{fieldName}''",
    values: {
      fieldName: fieldToEdit.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.flyoutDefaultTitle",
    defaultMessage: "Create field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.flyoutEditFieldSubtitle",
    defaultMessage: "Data view: {patternName}",
    values: {
      patternName: /*#__PURE__*/_react.default.createElement("i", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 36
        }
      }, dataView.getName())
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 19
    }
  }))), dataView.managed && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.disabledSaveCalloutMessage,
    color: "primary",
    iconType: "info",
    size: "s",
    css: {
      marginTop: euiTheme.base
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_field_editor.FieldEditor, {
    field: fieldToEdit !== null && fieldToEdit !== void 0 ? fieldToEdit : fieldToCreate,
    onChange: setFormState,
    onFormModifiedChange: setIsFormModified,
    isDisabled: dataView.managed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Footer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onClickCancel,
    "data-test-subj": "closeFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 19
    }
  }, i18nTexts.cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: onClickSave,
    "data-test-subj": "fieldSaveButton",
    fill: true,
    disabled: hasErrors || dataView.managed,
    isLoading: isSavingField || isSubmitting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 19
    }
  }, i18nTexts.saveButtonLabel)))))), isPanelVisible && /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    width: 440,
    backgroundColor: "euiPageBackground",
    border: "left",
    "data-test-subj": "previewPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_preview.FieldPreview, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 13
    }
  }))), renderModal());
};
const FieldEditorFlyoutContent = exports.FieldEditorFlyoutContent = /*#__PURE__*/_react.default.memo(FieldEditorFlyoutContentComponent);