"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubmittingType = exports.Footer = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/footer/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let SubmittingType = exports.SubmittingType = /*#__PURE__*/function (SubmittingType) {
  SubmittingType["savingAsAdHoc"] = "savingAsAdHoc";
  SubmittingType["persisting"] = "persisting";
  return SubmittingType;
}({});
const closeButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutCloseButtonLabel', {
  defaultMessage: 'Close'
});
const saveButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutSaveButtonLabel', {
  defaultMessage: 'Save data view to Kibana'
});
const editButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutEditButtonLabel', {
  defaultMessage: 'Save'
});
const duplicateButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutDuplicateButtonLabel', {
  defaultMessage: 'Duplicate'
});
const editUnpersistedButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutEditUnpersistedButtonLabel', {
  defaultMessage: 'Continue to use without saving'
});
const exploreButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutExploreButtonLabel', {
  defaultMessage: 'Use without saving'
});
const Footer = ({
  onCancel,
  onSubmit,
  submittingType,
  submitDisabled,
  hasEditData,
  allowAdHoc,
  isPersisted,
  canSave,
  onDuplicate,
  isManaged,
  isDuplicating
}) => {
  const isEditingAdHoc = hasEditData && !isPersisted;
  const isEditing = (canSave || isEditingAdHoc) && !isManaged;
  const showDuplicateButton = (canSave || isEditingAdHoc) && onDuplicate;
  const submitPersisted = () => {
    onSubmit(false);
  };
  const submitAdHoc = () => {
    onSubmit(true);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onCancel,
    "data-test-subj": "closeFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, closeButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, showDuplicateButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: onDuplicate,
    "data-test-subj": "duplicateButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 17
    }
  }, duplicateButtonLabel)), allowAdHoc && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: submitAdHoc,
    "data-test-subj": "exploreIndexPatternButton",
    disabled: submitDisabled,
    isLoading: submittingType === SubmittingType.savingAsAdHoc,
    title: _i18n.i18n.translate('indexPatternEditor.editor.flyoutExploreButtonTitle', {
      defaultMessage: 'Use this data view without creating a saved object'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }, exploreButtonLabel)), isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: submitPersisted,
    "data-test-subj": "saveIndexPatternButton",
    fill: true,
    disabled: submitDisabled,
    isLoading: submittingType === SubmittingType.persisting || submittingType === SubmittingType.savingAsAdHoc && isEditingAdHoc,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }, hasEditData && !isDuplicating ? isPersisted ? editButtonLabel : editUnpersistedButtonLabel : saveButtonLabel))))));
};
exports.Footer = Footer;