"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openSearchSessionsFlyout = openSearchSessionsFlyout;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _api = require("../lib/api");
var _flyout = require("./flyout");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/flyout/get_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function openSearchSessionsFlyout({
  coreStart,
  kibanaVersion,
  usageCollector,
  config,
  sessionsClient,
  share
}) {
  return (attrs = {}) => {
    const api = new _api.SearchSessionsMgmtAPI(sessionsClient, config, {
      notifications: coreStart.notifications,
      application: coreStart.application,
      usageCollector,
      featureFlags: coreStart.featureFlags
    });
    const {
      Provider: KibanaReactContextProvider
    } = (0, _public.createKibanaReactContext)(coreStart);
    const flyout = coreStart.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_flyout.Flyout, {
      onClose: () => flyout.close(),
      onBackgroundSearchOpened: params => {
        var _attrs$onBackgroundSe;
        (_attrs$onBackgroundSe = attrs.onBackgroundSearchOpened) === null || _attrs$onBackgroundSe === void 0 ? void 0 : _attrs$onBackgroundSe.call(attrs, params);
        flyout.close();
      },
      appId: attrs.appId,
      api: api,
      coreStart: coreStart,
      usageCollector: usageCollector,
      config: config,
      kibanaVersion: kibanaVersion,
      locators: share.url.locators,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }))), coreStart), {
      hideCloseButton: true,
      size: _constants.FLYOUT_WIDTH
    });
    return {
      flyout
    };
  };
}