"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _base_path = require("./base_path");
var _static_assets = require("./static_assets");
var _anonymous_paths_service = require("./anonymous_paths_service");
var _loading_count_service = require("./loading_count_service");
var _fetch = require("./fetch");
var _external_url_service = require("./external_url_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class HttpService {
  constructor() {
    (0, _defineProperty2.default)(this, "anonymousPaths", new _anonymous_paths_service.AnonymousPathsService());
    (0, _defineProperty2.default)(this, "loadingCount", new _loading_count_service.LoadingCountService());
    (0, _defineProperty2.default)(this, "service", void 0);
  }
  setup({
    injectedMetadata,
    fatalErrors,
    executionContext
  }) {
    const kibanaVersion = injectedMetadata.getKibanaVersion();
    const buildNumber = injectedMetadata.getKibanaBuildNumber();
    const basePath = new _base_path.BasePath({
      basePath: injectedMetadata.getBasePath(),
      serverBasePath: injectedMetadata.getServerBasePath(),
      publicBaseUrl: injectedMetadata.getPublicBaseUrl(),
      assetsHrefBase: injectedMetadata.getAssetsHrefBase()
    });
    const staticAssets = new _static_assets.StaticAssets({
      assetsHrefBase: injectedMetadata.getAssetsHrefBase()
    });
    const fetchService = new _fetch.Fetch({
      basePath,
      kibanaVersion,
      buildNumber,
      executionContext
    });
    const loadingCount = this.loadingCount.setup({
      fatalErrors
    });
    loadingCount.addLoadingCountSource(fetchService.getRequestCount$());
    this.service = {
      basePath,
      staticAssets,
      anonymousPaths: this.anonymousPaths.setup({
        basePath
      }),
      externalUrl: new _external_url_service.ExternalUrlService().setup({
        injectedMetadata,
        location: window.location
      }),
      intercept: fetchService.intercept.bind(fetchService),
      fetch: fetchService.fetch.bind(fetchService),
      delete: fetchService.delete.bind(fetchService),
      get: fetchService.get.bind(fetchService),
      head: fetchService.head.bind(fetchService),
      options: fetchService.options.bind(fetchService),
      patch: fetchService.patch.bind(fetchService),
      post: fetchService.post.bind(fetchService),
      put: fetchService.put.bind(fetchService),
      ...loadingCount
    };
    return this.service;
  }
  start() {
    if (!this.service) {
      throw new Error(`HttpService#setup() must be called first!`);
    }
    return this.service;
  }
  stop() {
    this.loadingCount.stop();
  }
}
exports.HttpService = HttpService;