"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavFooterItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _beta_badge = require("../beta_badge");
var _constants = require("../../constants");
var _focus_main_content = require("../../utils/focus_main_content");
var _use_tooltip = require("../../hooks/use_tooltip");
var _use_high_contrast_mode_styles = require("../../hooks/use_high_contrast_mode_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/footer_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Toggle button pattern: https://eui.elastic.co/docs/components/navigation/buttons/button/#toggle-button
 */
const SideNavFooterItem = exports.SideNavFooterItem = /*#__PURE__*/(0, _react.forwardRef)(({
  badgeType,
  hasContent,
  iconType,
  id,
  isCurrent,
  isHighlighted,
  label,
  ...props
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    tooltipRef,
    handleMouseOut
  } = (0, _use_tooltip.useTooltip)();
  // TODO: remove once the fix is available on EUI side
  const highContrastModeStyles = (0, _use_high_contrast_mode_styles.useHighContrastModeStyles)();
  const handleFooterItemKeyDown = e => {
    if (e.key === 'Enter' || e.key === ' ') {
      // Required for entering the popover with Enter or Space key
      // Otherwise the navigation happens immediately
      e.preventDefault();
      (0, _focus_main_content.focusMainContent)();
    }
  };
  const wrapperStyles = (0, _react2.css)`
      display: flex;
      justify-content: center;
      width: 100%;
    `;
  const buttonStyles = (0, _react2.css)`
      --high-contrast-hover-indicator-color: ${isHighlighted ? euiTheme.colors.textPrimary : euiTheme.colors.textParagraph};
      ${highContrastModeStyles}
    `;
  const buttonProps = {
    'aria-current': isCurrent ? 'page' : undefined,
    'aria-label': label,
    buttonRef: ref,
    color: isHighlighted ? 'primary' : 'text',
    'data-highlighted': isHighlighted ? 'true' : 'false',
    'data-test-subj': `footerMenuItem-${id}`,
    'data-menu-item': 'true',
    display: isHighlighted ? 'base' : 'empty',
    iconType: 'empty',
    // `iconType` is passed in Suspense below
    onKeyDown: handleFooterItemKeyDown,
    size: 's',
    css: buttonStyles,
    ...props
  };
  const menuItem = /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
      buttonRef: ref
    }, buttonProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 27
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    buttonRef: ref
  }, buttonProps, {
    iconType: iconType || 'empty',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })));
  if (!hasContent) {
    const tooltipStyles = (0, _react2.css)`
        display: flex;
        align-items: center;
        gap: ${euiTheme.size.s};
      `;
    const tooltipContent = badgeType ? /*#__PURE__*/_react.default.createElement("span", {
      css: tooltipStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, label, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
      type: badgeType,
      isInverted: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    })) : label;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorProps: {
        css: wrapperStyles
      },
      content: tooltipContent,
      disableScreenReaderOutput: true,
      onMouseOut: handleMouseOut,
      position: "right",
      ref: tooltipRef,
      repositionOnScroll: true,
      offset: _constants.TOOLTIP_OFFSET,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, menuItem);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: wrapperStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 12
    }
  }, menuItem);
});