"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_popover_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const aggregationToggleButtons = [{
  id: 'optionsList__includeResults',
  key: 'optionsList__includeResults',
  label: _options_list_strings.OptionsListStrings.popover.getIncludeLabel()
}, {
  id: 'optionsList__excludeResults',
  key: 'optionsList__excludeResults',
  label: _options_list_strings.OptionsListStrings.popover.getExcludeLabel()
}];
const OptionsListPopoverFooter = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    componentApi
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [exclude, loading, allowExpensiveQueries] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.exclude$, componentApi.dataLoading$, componentApi.parentApi.allowExpensiveQueries$);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "none",
    css: (0, _react2.css)`
          background-color: ${(0, _eui.useEuiBackgroundColor)('subdued')};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, loading && /*#__PURE__*/_react.default.createElement("div", {
    css: {
      position: 'absolute',
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "optionsList-control-popover-loading",
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    css: (0, _react2.css)`
            padding: ${(0, _eui.useEuiPaddingSize)('s')};
          `,
    justifyContent: 'spaceBetween',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _options_list_strings.OptionsListStrings.popover.getIncludeExcludeLegend(),
    options: aggregationToggleButtons,
    idSelected: exclude ? 'optionsList__excludeResults' : 'optionsList__includeResults',
    onChange: optionId => componentApi.setExclude(optionId === 'optionsList__excludeResults'),
    buttonSize: "compressed",
    "data-test-subj": "optionsList__includeExcludeButtonGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  })), !allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "optionsList-allow-expensive-queries-warning",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "warning",
    color: euiTheme.colors.textWarning,
    content: _options_list_strings.OptionsListStrings.popover.getAllowExpensiveQueriesWarning(),
    "aria-label": _options_list_strings.OptionsListStrings.popover.getAllowExpensiveQueriesWarning(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  })))));
};
exports.OptionsListPopoverFooter = OptionsListPopoverFooter;