"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudSecurityDataTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _cellActions = require("@kbn/cell-actions");
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_kibana = require("../../common/hooks/use_kibana");
var _empty_state = require("../empty_state");
var _use_styles = require("./use_styles");
var _additional_controls = require("./additional_controls");
var _data_view_context = require("../../common/contexts/data_view_context");
var _take_action = require("../take_action");
var _use_expandable_flyout_csp = require("../../common/hooks/use_expandable_flyout_csp");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_security_data_table/cloud_security_data_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const gridStyle = {
  border: 'horizontal',
  cellPadding: 'l',
  stripes: false,
  header: 'underline'
};

// Hide Checkbox, enable open details Flyout
const controlColumnIds = ['openDetails'];
const CloudSecurityDataTable = ({
  isLoading,
  defaultColumns,
  rows,
  total,
  onOpenFlyoutCallback,
  cloudPostureDataTable,
  loadMore,
  title,
  customCellRenderer,
  groupSelectorComponent,
  height,
  createRuleFn,
  columnHeaders,
  hasDistributionBar = true,
  flyoutType = 'misconfiguration',
  ...rest
}) => {
  const {
    columnsLocalStorageKey,
    pageSize,
    onChangeItemsPerPage,
    setUrlQuery,
    onSort,
    onResetFilters,
    filters,
    sort
  } = cloudPostureDataTable;
  const [columns, setColumns] = (0, _useLocalStorage.default)(columnsLocalStorageKey, defaultColumns.map(c => c.id));
  const [persistedSettings, setPersistedSettings] = (0, _useLocalStorage.default)(`${columnsLocalStorageKey}:settings`, {
    columns: defaultColumns.reduce((columnSettings, column) => {
      const columnDefaultSettings = column.width ? {
        width: column.width
      } : {};
      const newColumn = {
        [column.id]: columnDefaultSettings
      };
      return {
        ...columnSettings,
        ...newColumn
      };
    }, {})
  });
  const settings = (0, _react.useMemo)(() => {
    return {
      columns: Object.keys(persistedSettings === null || persistedSettings === void 0 ? void 0 : persistedSettings.columns).reduce((columnSettings, columnId) => {
        var _persistedSettings$co;
        const newColumn = {
          ..._lodash.default.pick(persistedSettings === null || persistedSettings === void 0 ? void 0 : (_persistedSettings$co = persistedSettings.columns) === null || _persistedSettings$co === void 0 ? void 0 : _persistedSettings$co[columnId], ['width']),
          display: columnHeaders === null || columnHeaders === void 0 ? void 0 : columnHeaders[columnId]
        };
        return {
          ...columnSettings,
          [columnId]: newColumn
        };
      }, {})
    };
  }, [persistedSettings, columnHeaders]);
  const {
    uiSettings,
    uiActions,
    dataViews,
    data,
    application,
    theme,
    fieldFormats,
    toastNotifications,
    storage
  } = (0, _use_kibana.useKibana)().services;
  const styles = (0, _use_styles.useStyles)();
  const {
    dataView,
    dataViewIsRefetching
  } = (0, _data_view_context.useDataViewContext)();
  const {
    capabilities
  } = application;
  const {
    columns: currentColumns,
    onSetColumns,
    onAddColumn,
    onRemoveColumn
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState: props => setColumns(props.columns),
    columns,
    sort
  });

  /**
   * This object is used to determine if the table rendering will be virtualized and the virtualization wrapper height.
   * mode should be passed as a key to the UnifiedDataTable component to force a re-render when the mode changes.
   */
  const computeDataTableRendering = (0, _react.useMemo)(() => {
    // Enable virtualization mode when the table is set to a large page size.
    const isVirtualizationEnabled = pageSize >= 100;
    const getWrapperHeight = () => {
      if (height) return height;

      // If virtualization is not needed the table will render unconstrained.
      if (!isVirtualizationEnabled) return 'auto';
      const baseHeight = 362; // height of Kibana Header + Findings page header and search bar
      const filterBarHeight = (filters === null || filters === void 0 ? void 0 : filters.length) > 0 ? 40 : 0;
      const distributionBarHeight = hasDistributionBar ? 52 : 0;
      return `calc(100vh - ${baseHeight}px - ${filterBarHeight}px - ${distributionBarHeight}px)`;
    };
    return {
      wrapperHeight: getWrapperHeight(),
      mode: isVirtualizationEnabled ? 'virtualized' : 'standard'
    };
  }, [pageSize, height, filters === null || filters === void 0 ? void 0 : filters.length, hasDistributionBar]);
  const {
    filterManager
  } = data.query;
  const onAddFilter = (0, _react.useMemo)(() => filterManager && dataView ? (clickedField, values, operation) => {
    const newFilters = (0, _public.generateFilters)(filterManager, clickedField, values, operation, dataView);
    filterManager.addFilters(newFilters);
    setUrlQuery({
      filters: filterManager.getFilters()
    });
  } : undefined, [dataView, filterManager, setUrlQuery]);
  const externalCustomRenderers = (0, _react.useMemo)(() => {
    if (!customCellRenderer) {
      return undefined;
    }
    return customCellRenderer(rows);
  }, [customCellRenderer, rows]);
  const {
    expandedDoc,
    onExpandDocClick
  } = (0, _use_expandable_flyout_csp.useExpandableFlyoutCsp)(flyoutType);
  if (!onExpandDocClick) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const services = {
    theme,
    fieldFormats,
    uiSettings,
    toastNotifications,
    storage,
    data
  };
  const onResize = colSettings => {
    const grid = persistedSettings || {};
    const newColumns = {
      ...(grid.columns || {})
    };
    newColumns[colSettings.columnId] = colSettings.width ? {
      width: Math.round(colSettings.width)
    } : {};
    const newGrid = {
      ...grid,
      columns: newColumns
    };
    setPersistedSettings(newGrid);
  };
  const onResetColumns = () => {
    setColumns(defaultColumns.map(c => c.id));
  };
  if (!isLoading && !rows.length) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 12
      }
    });
  }
  const externalAdditionalControls = /*#__PURE__*/_react.default.createElement(_additional_controls.AdditionalControls, {
    total: total,
    dataView: dataView,
    title: title,
    columns: currentColumns,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    groupSelectorComponent: groupSelectorComponent,
    onResetColumns: onResetColumns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 5
    }
  });
  const externalControlColumns = createRuleFn ? [{
    id: 'select',
    width: 20,
    headerCellRender: () => null,
    rowCellRender: ({
      rowIndex
    }) => createRuleFn && /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
      isDataGridControlColumn: true,
      createRuleFn: createRuleFn(rowIndex),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 15
      }
    })
  }] : undefined;
  const rowHeightState = 0;
  const loadingStyle = {
    opacity: isLoading ? 1 : 0
  };
  const loadingState = isLoading || dataViewIsRefetching ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded;
  return /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": rest['data-test-subj'],
    className: styles.gridContainer,
    style: {
      height: computeDataTableRendering.wrapperHeight
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    css: loadingStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTable, {
    key: computeDataTableRendering.mode,
    className: styles.gridStyle,
    ariaLabelledBy: title,
    columns: currentColumns,
    expandedDoc: expandedDoc,
    dataView: dataView,
    loadingState: loadingState,
    onFilter: onAddFilter,
    onResize: onResize,
    onSetColumns: onSetColumns,
    onSort: onSort,
    rows: rows,
    sampleSizeState: _cloudSecurityPostureCommon.MAX_FINDINGS_TO_LOAD,
    setExpandedDoc: onExpandDocClick,
    renderDocumentView: onOpenFlyoutCallback,
    sort: sort,
    rowsPerPageState: pageSize,
    totalHits: total,
    services: services,
    onUpdateRowsPerPage: onChangeItemsPerPage,
    rowHeightState: rowHeightState,
    showMultiFields: uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    showTimeCol: false,
    settings: settings,
    onFetchMoreRecords: loadMore,
    externalControlColumns: externalControlColumns,
    externalCustomRenderers: externalCustomRenderers,
    externalAdditionalControls: externalAdditionalControls,
    gridStyleOverride: gridStyle,
    rowLineHeightOverride: "24px",
    controlColumnIds: controlColumnIds,
    dataGridDensityState: _unifiedDataTable.DataGridDensity.EXPANDED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  })));
};
exports.CloudSecurityDataTable = CloudSecurityDataTable;