"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateSelectorComponent = exports.TemplateSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _optional_field_label = require("../optional_field_label");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/create/templates.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplateSelectorComponent = ({
  isLoading,
  templates,
  initialTemplate,
  isDisabled,
  onTemplateChange
}) => {
  var _initialTemplate$key;
  const [selectedTemplate, onSelectTemplate] = (0, _react.useState)((_initialTemplate$key = initialTemplate === null || initialTemplate === void 0 ? void 0 : initialTemplate.key) !== null && _initialTemplate$key !== void 0 ? _initialTemplate$key : undefined);
  const options = templates.map(template => ({
    text: template.name,
    value: template.key
  }));
  const onChange = (0, _react.useCallback)(e => {
    const updatedTemplate = templates.find(template => template.key === e.target.value);
    if (updatedTemplate) {
      onSelectTemplate(updatedTemplate.key);
      onTemplateChange({
        key: updatedTemplate.key,
        caseFields: updatedTemplate.caseFields
      });
    }
  }, [onTemplateChange, templates]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "createCaseTemplate",
    fullWidth: true,
    label: _translations.TEMPLATE_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      css: (0, _react2.css)`
            flex-grow: 0;
          `,
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, _optional_field_label.OptionalFieldLabel)),
    helpText: _translations.TEMPLATE_HELP_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    onChange: onChange,
    options: options,
    disabled: isLoading || isDisabled,
    isLoading: isLoading,
    "data-test-subj": "create-case-template-select",
    fullWidth: true,
    value: selectedTemplate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
};
exports.TemplateSelectorComponent = TemplateSelectorComponent;
TemplateSelectorComponent.displayName = 'TemplateSelector';
const TemplateSelector = exports.TemplateSelector = /*#__PURE__*/_react.default.memo(TemplateSelectorComponent);