"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourceSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/datasource/datasource_selector.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasourceSelector = ({
  onSelect,
  datasources,
  current
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasDataSource__list",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 13,
    columnNumber: 3
  }
}, datasources.map(d => /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  key: d.name,
  title: d.displayName,
  titleElement: "h5",
  titleSize: "xs",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: d.image,
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 15
    }
  }),
  description: d.help,
  layout: "horizontal",
  className: "canvasDataSource__card",
  selectable: {
    isSelected: d.name === current ? true : false,
    onClick: () => onSelect(d.name)
  },
  "data-test-subj": `canvasDatasourceCard__${d.name}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 15,
    columnNumber: 7
  }
})));
exports.DatasourceSelector = DatasourceSelector;
DatasourceSelector.propTypes = {
  onSelect: _propTypes.default.func.isRequired,
  datasources: _propTypes.default.array.isRequired,
  current: _propTypes.default.string.isRequired
};