"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDetails = TransactionDetails;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _aggregated_transactions_badge = require("../../shared/aggregated_transactions_badge");
var _transaction_charts = require("../../shared/charts/transaction_charts");
var _url_helpers = require("../../shared/links/url_helpers");
var _transaction_details_tabs = require("./transaction_details_tabs");
var _agent_name = require("../../../../common/agent_name");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _slo_callout = require("../../shared/slo_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TransactionDetails() {
  const {
    path,
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    transactionName,
    rangeFrom,
    rangeTo,
    transactionType: transactionTypeFromUrl,
    comparisonEnabled,
    offset,
    environment
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    transactionType,
    fallbackToTransactions,
    serverlessType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const history = (0, _reactRouterDom.useHistory)();

  // redirect to first transaction type
  if (!transactionTypeFromUrl && transactionType) {
    (0, _url_helpers.replace)(history, {
      query: {
        transactionType
      }
    });
  }
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title: transactionName,
    href: apmRouter.link('/services/{serviceName}/transactions/view', {
      path,
      query
    })
  }), [apmRouter, path, query, transactionName]);
  const isServerless = (0, _agent_name.isServerlessAgentName)(serverlessType);
  const [sloCalloutDismissed, setSloCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.sloCalloutDismissed', false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !sloCalloutDismissed && /*#__PURE__*/_react.default.createElement(_slo_callout.SloCallout, {
    dismissCallout: () => {
      setSloCalloutDismissed(true);
    },
    serviceName: serviceName,
    environment: environment,
    transactionType: transactionType,
    transactionName: transactionName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }), fallbackToTransactions && /*#__PURE__*/_react.default.createElement(_aggregated_transactions_badge.AggregatedTransactionsBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 34
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, transactionName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_charts.TransactionCharts, {
    serviceName: serviceName,
    kuery: query.kuery,
    environment: query.environment,
    start: start,
    end: end,
    transactionName: transactionName,
    isServerlessContext: isServerless,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_transaction_details_tabs.TransactionDetailsTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
}