"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snoozeRuleRoute = void 0;
var _validate_internal_rule_type = require("../../../../lib/validate_internal_rule_type");
var _snooze = require("../../../../../../common/routes/rule/apis/snooze");
var _lib = require("../../../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../../types");
var _transforms = require("./transforms");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const snoozeRuleRoute = (router, licenseState) => {
  router.post({
    path: _types.INTERNAL_ALERTING_SNOOZE_RULE,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _snooze.snoozeParamsInternalSchemaV1,
      body: _snooze.snoozeBodyInternalSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const ruleTypes = alertingContext.listTypes();
    const params = req.params;
    const body = (0, _transforms.transformSnoozeBodyV1)(req.body);
    try {
      const rule = await rulesClient.get({
        id: params.id
      });
      (0, _validate_internal_rule_type.validateInternalRuleType)({
        ruleTypeId: rule.alertTypeId,
        ruleTypes,
        operationText: 'snooze'
      });
      await rulesClient.snooze({
        ...params,
        ...body
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleMutedError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.snoozeRuleRoute = snoozeRuleRoute;