"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBarWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Reusable search bar component for the AIOps app.
 *
 * @param query
 * @param filters
 * @param onQueryChange
 * @param onFiltersChange
 * @constructor
 */
const SearchBarWrapper = ({
  query,
  filters,
  onQueryChange,
  onFiltersChange
}) => {
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [error, setError] = (0, _react.useState)();
  const onQuerySubmit = (0, _react.useCallback)((payload, isUpdate) => {
    var _payload$query;
    if (((_payload$query = payload.query) === null || _payload$query === void 0 ? void 0 : _payload$query.language) === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY) {
      try {
        // Validates the query
        (0, _esQuery.fromKueryExpression)(payload.query.query);
        setError(undefined);
        onQueryChange(payload.query);
      } catch (e) {
        setError(e.message);
      }
    }
  }, [onQueryChange]);
  const onFiltersUpdated = (0, _react.useCallback)(updatedFilters => {
    onFiltersChange(updatedFilters);
  }, [onFiltersChange]);
  const resultQuery = query !== null && query !== void 0 ? query : {
    query: '',
    language: 'kuery'
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    showSubmitButton: false,
    appName: 'aiops',
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: true,
    query: resultQuery,
    showSavedQueryControls: false,
    filters: filters !== null && filters !== void 0 ? filters : [],
    onQuerySubmit: onQuerySubmit,
    indexPatterns: [dataView],
    placeholder: _i18n.i18n.translate('xpack.aiops.searchPanel.queryBarPlaceholderText', {
      defaultMessage: 'Search… (e.g. status:200 AND extension:"PHP")'
    }),
    displayStyle: 'inPage',
    isClearable: true,
    onFiltersUpdated: onFiltersUpdated,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, error)) : null);
};
exports.SearchBarWrapper = SearchBarWrapper;