"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Listing = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ = require("..");
var _format_number = require("../../../lib/format_number");
var _table = require("../../table");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _listing_callout = require("../../setup_mode/listing_callout");
var _badge = require("../../setup_mode/badge");
var _i18nReact = require("@kbn/i18n-react");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/beats/listing/listing.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Listing extends _react.PureComponent {
  getColumns() {
    const setupMode = this.props.setupMode;
    return [{
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.nameTitle', {
        defaultMessage: 'Name'
      }),
      field: 'name',
      render: (name, beat) => {
        let setupModeStatus = null;
        if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
          const list = (0, _lodash.get)(setupMode, 'data.byUuid', {});
          const status = list[beat.uuid] || {};
          const instance = {
            uuid: beat.uuid,
            name: beat.name
          };
          setupModeStatus = /*#__PURE__*/_react.default.createElement(_badge.SetupModeBadge, {
            setupMode: setupMode,
            status: status,
            instance: instance,
            productName: _constants.BEATS_SYSTEM_ID,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 51,
              columnNumber: 15
            }
          });
        }
        return /*#__PURE__*/_react.default.createElement("div", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/beats/beat/${beat.uuid}`),
          "data-test-subj": `beatLink-${name}`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 15
          }
        }, name), setupModeStatus);
      }
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.typeTitle', {
        defaultMessage: 'Type'
      }),
      field: 'type'
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.outputEnabledTitle', {
        defaultMessage: 'Output Enabled'
      }),
      field: 'output'
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.totalEventsRateTitle', {
        defaultMessage: 'Total Events Rate'
      }),
      field: 'total_events_rate',
      render: value => (0, _format_number.formatMetric)(value, '', '/s')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.bytesSentRateTitle', {
        defaultMessage: 'Bytes Sent Rate'
      }),
      field: 'bytes_sent_rate',
      render: value => (0, _format_number.formatMetric)(value, 'byte', '/s')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.outputErrorsTitle', {
        defaultMessage: 'Output Errors'
      }),
      field: 'errors',
      render: value => (0, _format_number.formatMetric)(value, '0')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.allocatedMemoryTitle', {
        defaultMessage: 'Allocated Memory'
      }),
      field: 'memory',
      render: value => (0, _format_number.formatMetric)(value, 'byte')
    }, {
      name: _i18n.i18n.translate('xpack.monitoring.beats.instances.versionTitle', {
        defaultMessage: 'Version'
      }),
      field: 'version'
    }];
  }
  render() {
    const {
      stats,
      data,
      sorting,
      pagination,
      onTableChange,
      setupMode
    } = this.props;
    let setupModeCallOut = null;
    if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
      setupModeCallOut = /*#__PURE__*/_react.default.createElement(_listing_callout.ListingCallOut, {
        setupModeData: setupMode.data,
        useNodeIdentifier: false,
        productName: _constants.BEATS_SYSTEM_ID,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 9
        }
      });
    }
    const types = (0, _lodash.uniq)(data.map(item => item.type)).map(type => {
      return {
        value: type
      };
    });
    const versions = (0, _lodash.uniq)(data.map(item => item.version)).map(version => {
      return {
        value: version
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.beats.listing.heading",
      defaultMessage: "Beats listing",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_.Stats, {
      stats: stats,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }, setupModeCallOut, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
      "data-test-subj": "beatsTable",
      rows: data,
      setupMode: setupMode,
      productName: _constants.BEATS_SYSTEM_ID,
      columns: this.getColumns(),
      sorting: sorting,
      pagination: pagination,
      search: {
        box: {
          incremental: true,
          placeholder: _i18n.i18n.translate('xpack.monitoring.beats.filterBeatsPlaceholder', {
            defaultMessage: 'Filter Beats...'
          })
        },
        filters: [{
          type: 'field_value_selection',
          field: 'type',
          name: _i18n.i18n.translate('xpack.monitoring.beats.instances.typeFilter', {
            defaultMessage: 'Type'
          }),
          options: types,
          multiSelect: 'or'
        }, {
          type: 'field_value_selection',
          field: 'version',
          name: _i18n.i18n.translate('xpack.monitoring.beats.instances.versionFilter', {
            defaultMessage: 'Version'
          }),
          options: versions,
          multiSelect: 'or'
        }]
      },
      onTableChange: onTableChange,
      executeQueryOptions: {
        defaultFields: ['name', 'type']
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }))));
  }
}
exports.Listing = Listing;