"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertConfiguration = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _lib = require("@kbn/response-ops-rule-form/lib");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _setup_mode = require("../lib/setup_mode");
var _legacy_shims = require("../legacy_shims");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertConfiguration = props => {
  const {
    alert,
    compressed
  } = props;
  const [showFlyout, setShowFlyout] = _react.default.useState(false);
  const [isEnabled, setIsEnabled] = _react.default.useState(alert.enabled);
  const [isMuted, setIsMuted] = _react.default.useState(alert.muteAll);
  const [isSaving, setIsSaving] = _react.default.useState(false);
  const {
    services
  } = (0, _public.useKibana)();
  async function disableAlert() {
    setIsSaving(true);
    try {
      await _legacy_shims.Legacy.shims.http.post(`${_common.BASE_ALERTING_API_PATH}/rule/${alert.id}/_disable`);
    } catch (err) {
      _legacy_shims.Legacy.shims.toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.alerts.panel.disableAlert.errorTitle', {
          defaultMessage: `Unable to disable rule`
        }),
        text: err.message
      });
    }
    setIsSaving(false);
  }
  async function enableAlert() {
    setIsSaving(true);
    try {
      await _legacy_shims.Legacy.shims.http.post(`${_common.BASE_ALERTING_API_PATH}/rule/${alert.id}/_enable`);
    } catch (err) {
      _legacy_shims.Legacy.shims.toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.alerts.panel.enableAlert.errorTitle', {
          defaultMessage: `Unable to enable rule`
        }),
        text: err.message
      });
    }
    setIsSaving(false);
  }
  async function muteAlert() {
    setIsSaving(true);
    try {
      await _legacy_shims.Legacy.shims.http.post(`${_common.BASE_ALERTING_API_PATH}/rule/${alert.id}/_mute_all`);
    } catch (err) {
      _legacy_shims.Legacy.shims.toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.alerts.panel.muteAlert.errorTitle', {
          defaultMessage: `Unable to mute rule`
        }),
        text: err.message
      });
    }
    setIsSaving(false);
  }
  async function unmuteAlert() {
    setIsSaving(true);
    try {
      await _legacy_shims.Legacy.shims.http.post(`${_common.BASE_ALERTING_API_PATH}/rule/${alert.id}/_unmute_all`);
    } catch (err) {
      _legacy_shims.Legacy.shims.toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.alerts.panel.ummuteAlert.errorTitle', {
          defaultMessage: `Unable to unmute rule`
        }),
        text: err.message
      });
    }
    setIsSaving(false);
  }
  const onClose = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    (0, _setup_mode.showBottomBar)();
  }, []);
  const {
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    }
  } = _legacy_shims.Legacy.shims;
  const flyoutUi = (0, _react.useMemo)(() => showFlyout && (0, _lib.isValidRuleFormPlugins)(services) && /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ruleTypeRegistry,
      actionTypeRegistry,
      ...services
    },
    id: alert.id,
    onSubmit: onClose,
    onCancel: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [showFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: compressed ? 'flexStart' : 'spaceBetween',
    gutterSize: compressed ? 'm' : 'xs',
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: compressed ? 's' : 'm',
    onClick: () => {
      setShowFlyout(true);
      (0, _setup_mode.hideBottomBar)();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.monitoring.alerts.panel.editAlert', {
    defaultMessage: `Edit rule`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "disable",
    disabled: isSaving,
    checked: !isEnabled,
    onChange: async () => {
      if (isEnabled) {
        setIsEnabled(false);
        await disableAlert();
      } else {
        setIsEnabled(true);
        await enableAlert();
      }
    },
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.alerts.panel.disableTitle",
      defaultMessage: "Disable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "mute",
    disabled: isSaving,
    checked: isMuted,
    "data-test-subj": "muteSwitch",
    onChange: async () => {
      if (isMuted) {
        setIsMuted(false);
        await unmuteAlert();
      } else {
        setIsMuted(true);
        await muteAlert();
      }
    },
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.alerts.panel.muteTitle",
      defaultMessage: "Mute",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }))), flyoutUi);
};
exports.AlertConfiguration = AlertConfiguration;