"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.explorerRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _resolvers = require("../../resolvers");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _job_service = require("../../../services/job_service");
var _explorer_utils = require("../../../explorer/explorer_utils");
var _breadcrumbs = require("../../breadcrumbs");
var _ml_annotation_updates_context = require("../../../contexts/ml/ml_annotation_updates_context");
var _annotations_service = require("../../../services/annotations_service");
var _anomaly_explorer_context = require("../../../explorer/anomaly_explorer_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/explorer/explorer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExplorerUrlStateManager = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./state_manager')))).ExplorerUrlStateManager
}));
const explorerRouteFactory = (navigateToPath, basePath) => ({
  id: 'explorer',
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_EXPLORER),
  title: _i18n.i18n.translate('xpack.ml.anomalyDetection.anomalyExplorer.docTitle', {
    defaultMessage: 'Anomaly Explorer'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 28
    }
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.anomalyDetection.anomalyExplorerLabel', {
      defaultMessage: 'Anomaly Explorer'
    })
  }],
  enableDatePicker: true,
  'data-test-subj': 'mlPageAnomalyExplorer'
});
exports.explorerRouteFactory = explorerRouteFactory;
const PageWrapper = () => {
  const {
    services: {
      mlServices: {
        mlApi
      },
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const mlJobService = (0, _job_service.useMlJobService)();
  const {
    context,
    results
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    ...(0, _resolvers.basicResolvers)(),
    jobs: mlJobService.loadJobsWrapper,
    jobsWithTimeRange: () => mlApi.jobs.jobsWithTimerange((0, _explorer_utils.getDateFormatTz)(uiSettings))
  });
  const annotationUpdatesService = (0, _react.useMemo)(() => new _annotations_service.AnnotationUpdatesService(), []);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_annotation_updates_context.MlAnnotationUpdatesContext.Provider, {
    value: annotationUpdatesService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_explorer_context.AnomalyExplorerContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, results ? /*#__PURE__*/_react.default.createElement(ExplorerUrlStateManager, {
    jobsWithTimeRange: results.jobsWithTimeRange.jobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }) : null)));
};