"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ml_entity_selector = require("../../components/ml_entity_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/notifications/components/entity_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Custom filter component to use with {@link EuiInMemoryTable}
 */
const EntityFilter = exports.EntityFilter = /*#__PURE__*/_react.default.memo(({
  query,
  onChange
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const hasActiveFilters = query.hasOrFieldClause('job_id') || query.hasSimpleFieldClause('job_id');
  const orFieldClause = query.getOrFieldClause('job_id');
  const simpleFieldClause = query.getSimpleFieldClause('job_id');
  const closePopover = setIsOpen.bind(null, false);
  const selectedOptions = (0, _react.useMemo)(() => {
    let options = [];
    if (orFieldClause && Array.isArray(orFieldClause.value)) {
      options = orFieldClause.value.map(v => ({
        id: v
      }));
    }
    if (simpleFieldClause && simpleFieldClause.value) {
      options.push({
        id: simpleFieldClause.value
      });
    }
    return options;
  }, [orFieldClause, simpleFieldClause]);
  const onSelectionChange = (0, _react.useCallback)(entitiesSelection => {
    // first clean up
    let newQuery = query.removeOrFieldClauses('job_id');
    newQuery = newQuery.removeSimpleFieldClauses('job_id');
    if (entitiesSelection.length > 0) {
      newQuery = (0, _lodash.uniqBy)(entitiesSelection, 'id').reduce((acc, curr) => {
        return acc.addOrFieldValue('job_id', curr.id, true, 'eq');
      }, newQuery);
    }
    onChange(newQuery);
  }, [onChange, query]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: setIsOpen.bind(null, prev => !prev),
    isSelected: isOpen,
    hasActiveFilters: hasActiveFilters,
    numActiveFilters: hasActiveFilters ? selectedOptions.length : undefined,
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.notifications.entityFilter",
    defaultMessage: "Entity",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    css: {
      width: '300px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_entity_selector.MlEntitySelector, {
    selectedOptions: selectedOptions,
    onSelectionChange: onSelectionChange,
    handleDuplicates: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })));
});