"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddModelFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _check_capabilities = require("../capabilities/check_capabilities");
var _kibana = require("../contexts/kibana");
var _eland_python_client = require("./eland_python_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/add_model_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Flyout for downloading elastic curated models and showing instructions for importing third-party models.
 */
const AddModelFlyout = ({
  onClose,
  onSubmit,
  modelDownloads
}) => {
  const canCreateTrainedModels = (0, _check_capabilities.usePermissionCheck)('canCreateTrainedModels');
  const isClickToDownloadTabVisible = canCreateTrainedModels && modelDownloads.length > 0;
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(isClickToDownloadTabVisible ? 'clickToDownload' : 'manualDownload');
  const tabs = (0, _react.useMemo)(() => {
    return [...(isClickToDownloadTabVisible ? [{
      id: 'clickToDownload',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.clickToDownloadTabLabel",
        defaultMessage: "Click to Download",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 17
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(ClickToDownloadTabContent, {
        modelDownloads: modelDownloads,
        onModelDownload: onSubmit,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 17
        }
      })
    }] : []), {
      id: 'manualDownload',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.thirdPartyLabel",
        defaultMessage: "Manual Download",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(ManualDownloadTabContent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 18
        }
      })
    }];
  }, [isClickToDownloadTabVisible, modelDownloads, onSubmit]);
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": 'addTrainedModelFlyout',
    "data-test-subj": 'mlAddTrainedModelFlyout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: 'addTrainedModelFlyout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.addModelFlyout.title",
    defaultMessage: "Add a trained model",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    isSelected: selectedTabId === tab.id,
    onClick: setSelectedTabId.bind(null, tab.id),
    "data-test-subj": `mlAddTrainedModelFlyoutTab ${tab.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, tab.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, selectedTabContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.addModelFlyout.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }))))));
};
exports.AddModelFlyout = AddModelFlyout;
/**
 * Tab content for selecting a model to download.
 */
const ClickToDownloadTabContent = ({
  modelDownloads,
  onModelDownload
}) => {
  var _modelDownloads$find;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const [selectedModelId, setSelectedModelId] = (0, _react.useState)((_modelDownloads$find = modelDownloads.find(m => m.recommended)) === null || _modelDownloads$find === void 0 ? void 0 : _modelDownloads$find.model_id);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.entries((0, _lodash.groupBy)(modelDownloads, 'modelName')).map(([modelName, models]) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: modelName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }, modelName === 'elser' ? /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's',
      alignItems: 'center',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic",
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.elserTitle",
      defaultMessage: "ELSER (Elastic Learned Sparse EncodeR)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 25
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 's',
      "data-test-subj": "mlAddTrainedModelFlyoutElserModelHeaderCopy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.addModelFlyout.elserDescription",
      defaultMessage: "ELSER is Elastic's NLP model for English semantic search, utilizing sparse vectors. It prioritizes intent and contextual meaning over literal term matching, optimized specifically for English documents and queries on the Elastic platform.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.ml.nlpElser,
      external: true,
      target: '_blank',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",
      defaultMessage: "View documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 17
      }
    })) : null, modelName === 'e5' ? /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.e5Title",
      defaultMessage: "E5 (EmbEddings from bidirEctional Encoder rEpresentations)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: 'subdued',
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.addModelFlyout.e5Description",
      defaultMessage: "E5 is a third party NLP model that enables you to perform multi-lingual semantic search by using dense vector representations. This model performs best for non-English language documents and queries.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 21
      }
    }), "\xA0", models[0].disclaimer)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'spaceBetween',
      gutterSize: 'none',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.ml.nlpE5,
      external: true,
      target: '_blank',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",
      defaultMessage: "View documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'l',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 17
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
      legend: {
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.chooseModelLabel",
          defaultMessage: "Choose a model",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 19
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 13
      }
    }, models.map((model, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: model.model_id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
        id: model.model_id,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: 's',
          alignItems: 'center',
          justifyContent: 'spaceBetween',
          "data-test-subj": "mlAddTrainedModelFlyoutChooseModelPanels",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 259,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 265,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement("header", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 266,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: 's',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 31
          }
        }, /*#__PURE__*/_react.default.createElement("b", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 268,
            columnNumber: 33
          }
        }, model.os === 'Linux' && model.arch === 'amd64' ? /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": `mlAddTrainedModelFlyoutModelPanel-${modelName}-${model.model_id}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 270,
            columnNumber: 37
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.intelLinuxLabel",
          defaultMessage: "Intel and Linux optimized",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 273,
            columnNumber: 39
          }
        })) : /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": `mlAddTrainedModelFlyoutModelPanel-${modelName}-${model.model_id}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 279,
            columnNumber: 37
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.crossPlatformLabel",
          defaultMessage: "Cross platform",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 282,
            columnNumber: 39
          }
        }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: 's',
          color: 'subdued',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 291,
            columnNumber: 29
          }
        }, model.model_id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 295,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: 's',
          alignItems: 'center',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 296,
            columnNumber: 29
          }
        }, model.recommended ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 298,
            columnNumber: 33
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.trainedModels.modelsList.recommendedDownloadContent",
            defaultMessage: "Recommended model version for your cluster's hardware configuration",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 301,
              columnNumber: 39
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 299,
            columnNumber: 35
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          tabIndex: 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 307,
            columnNumber: 37
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.addModelFlyout.recommendedDownloadLabel",
          defaultMessage: "Recommended",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 308,
            columnNumber: 39
          }
        })))) : null, model.licenseUrl && model.softwareLicense ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 317,
            columnNumber: 33
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          target: '_blank',
          href: model.licenseUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 318,
            columnNumber: 35
          }
        }, model.softwareLicense === 'MIT' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.mitLicenseLabel",
          defaultMessage: "License: MIT",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 324,
            columnNumber: 39
          }
        }) : null)) : null))),
        name: model.model_id,
        value: model.model_id,
        checked: model.model_id === selectedModelId,
        onChange: setSelectedModelId.bind(null, model.model_id),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 21
        }
      }), index < models.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 341,
          columnNumber: 50
        }
      }) : null);
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 13
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onModelDownload.bind(null, selectedModelId),
    fill: true,
    disabled: !selectedModelId,
    "data-test-subj": "mlAddTrainedModelFlyoutDownloadButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.addModelFlyout.downloadButtonLabel",
    defaultMessage: "Download",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 9
    }
  })));
};

/**
 * Manual download tab content for showing instructions for importing third-party models.
 */
const ManualDownloadTabContent = () => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  return /*#__PURE__*/_react.default.createElement(_eland_python_client.ElandPythonClient, {
    supportedNlpModels: docLinks.links.enterpriseSearch.supportedNlpModels,
    nlpImportModel: docLinks.links.ml.nlpImportModel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 5
    }
  });
};