"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultLinks = ResultLinks;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_create_ad_links = require("../../../../components/custom_hooks/use_create_ad_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/job_actions/results.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ResultLinks({
  jobs
}) {
  const openJobsInSingleMetricViewerText = _i18n.i18n.translate('xpack.ml.jobsList.resultActions.openJobsInSingleMetricViewerText', {
    defaultMessage: 'Open {jobsCount, plural, one {{jobId}} other {# jobs}} in Single Metric Viewer',
    values: {
      jobsCount: jobs.length,
      jobId: jobs[0].id
    }
  });
  const openJobsInAnomalyExplorerText = _i18n.i18n.translate('xpack.ml.jobsList.resultActions.openJobsInAnomalyExplorerText', {
    defaultMessage: 'Open {jobsCount, plural, one {{jobId}} other {# jobs}} in Anomaly Explorer',
    values: {
      jobsCount: jobs.length,
      jobId: jobs[0].id
    }
  });
  const singleMetricVisible = jobs.length < 2;
  const singleMetricEnabled = jobs.length === 1 && jobs[0].isSingleMetricViewerJob;
  const singleMetricDisabledMessage = jobs.length === 1 && jobs[0].isNotSingleMetricViewerJobMessage;
  const singleMetricDisabledMessageText = singleMetricDisabledMessage !== undefined ? _i18n.i18n.translate('xpack.ml.jobsList.resultActions.singleMetricDisabledMessageText', {
    defaultMessage: 'Disabled because {reason}.',
    values: {
      reason: singleMetricDisabledMessage
    }
  }) : undefined;
  const jobActionsDisabled = jobs.length === 1 && jobs[0].blocked !== undefined;
  const {
    createLinkWithUserDefaults
  } = (0, _use_create_ad_links.useCreateADLinks)();
  const timeSeriesExplorerLink = (0, _react.useMemo)(() => createLinkWithUserDefaults('timeseriesexplorer', jobs),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobs]);
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const anomalyExplorerLink = (0, _react.useMemo)(() => createLinkWithUserDefaults('explorer', jobs), [jobs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    wrap: false,
    direction: "row",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, singleMetricVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: singleMetricDisabledMessageText !== null && singleMetricDisabledMessageText !== void 0 ? singleMetricDisabledMessageText : openJobsInSingleMetricViewerText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    href: timeSeriesExplorerLink,
    iconType: "singleMetricViewer",
    "aria-label": openJobsInSingleMetricViewerText,
    isDisabled: singleMetricEnabled === false || jobActionsDisabled === true,
    "data-test-subj": "mlOpenJobsInSingleMetricViewerButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: openJobsInAnomalyExplorerText,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    href: anomalyExplorerLink,
    iconType: "visTable",
    "aria-label": openJobsInAnomalyExplorerText,
    isDisabled: jobActionsDisabled === true,
    "data-test-subj": "mlOpenJobsInAnomalyExplorerButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }))));
}
ResultLinks.propTypes = {
  jobs: _propTypes.default.array.isRequired
};