"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartLabel = ExplorerChartLabel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _explorer_chart_label_badge = require("./explorer_chart_label_badge");
var _explorer_chart_info_tooltip = require("../../explorer_chart_info_tooltip");
var _entity_filter = require("./entity_filter");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/components/explorer_chart_label/explorer_chart_label.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ExplorerChartLabel({
  detectorLabel,
  entityFields,
  infoTooltip,
  isEmbeddable,
  wrapLabel = false,
  onSelectEntity,
  showFilterIcons
}) {
  // Depending on whether we wrap the entityField badges to a new line, we render this differently:
  //
  // 1. All in one line:
  //   <detectorLabel> - <entityBadge1> <entityBadge2> ... <infoIcon>
  //
  // 2. Multiple lines:
  //   <detectorLabel> <infoIcon>
  //   <entityBadge1> <entityBadge2> ...

  // Using &nbsp;s here to make sure those spaces get rendered.
  const labelSeparator = wrapLabel === true || entityFields.length === 0 || detectorLabel.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0\u2013\xA0");
  const applyFilter = (0, _react.useCallback)(({
    influencerFieldName,
    influencerFieldValue,
    action
  }) => onSelectEntity(influencerFieldName, influencerFieldValue, action), [onSelectEntity]);
  const entityFieldBadges = entityFields.map(entity => {
    const key = `${infoTooltip.chartFunction}-${entity.fieldName}-${entity.fieldType}-${entity.fieldValue}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `badge-wrapper-${key}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_explorer_chart_label_badge.ExplorerChartLabelBadge, {
      entity: entity,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }), onSelectEntity !== undefined && showFilterIcons === true ? /*#__PURE__*/_react.default.createElement(_entity_filter.EntityFilter, {
      isEmbeddable: isEmbeddable,
      onFilter: applyFilter,
      influencerFieldName: entity.fieldName,
      influencerFieldValue: entity.fieldValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0"));
  });
  const infoIcon = /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    css: {
      maxWidth: 'none'
    },
    content: /*#__PURE__*/_react.default.createElement(_explorer_chart_info_tooltip.ExplorerChartInfoTooltip, (0, _extends2.default)({}, infoTooltip, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 18
      }
    })),
    position: "top",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const badgesStyles = (0, _react2.css)({
    display: 'flex',
    alignItems: 'center',
    marginTop: euiTheme.size.xs
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, detectorLabel, labelSeparator), wrapLabel && infoIcon, !wrapLabel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, entityFieldBadges, " ", infoIcon)), wrapLabel && /*#__PURE__*/_react.default.createElement("span", {
    css: badgesStyles,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 21
    }
  }, entityFieldBadges));
}
ExplorerChartLabel.propTypes = {
  detectorLabel: _propTypes.default.object.isRequired,
  isEmbeddable: _propTypes.default.bool,
  entityFields: _propTypes.default.arrayOf(_explorer_chart_label_badge.ExplorerChartLabelBadge.propTypes.entity),
  infoTooltip: _propTypes.default.object.isRequired,
  wrapLabel: _propTypes.default.bool
};