"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefDimensions = useRefDimensions;
var _react = require("react");
var _useWindowSize = _interopRequireDefault(require("react-use/lib/useWindowSize"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRefDimensions() {
  const ref = (0, _react.useRef)(null);
  const windowHeight = (0, _useWindowSize.default)().height;
  if (!ref.current) {
    return {
      ref,
      width: 0,
      height: 0
    };
  }
  const {
    top,
    width
  } = ref.current.getBoundingClientRect();
  const height = windowHeight - top;
  return {
    ref,
    width,
    height
  };
}