"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationStepWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _mlValidators = require("@kbn/ml-validators");
var _validation_step = require("./validation_step");
var _validation_step_details = require("./validation_step_details");
var _page = require("../../page");
var _kibana = require("../../../../../contexts/kibana");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/validation_step/validation_step_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ValidationStepWrapper = ({
  state,
  setCurrentStep,
  step,
  stepActivated
}) => {
  const [checksInProgress, setChecksInProgress] = (0, _react.useState)(false);
  const [validationMessages, setValidationMessages] = (0, _react.useState)([]);
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  const {
    form,
    jobConfig,
    isAdvancedEditorEnabled
  } = state;
  const {
    dependentVariable,
    jobType,
    trainingPercent,
    numTopFeatureImportanceValues,
    numTopClasses,
    includes
  } = form;
  const showValidationStep = step === _page.ANALYTICS_STEPS.VALIDATION;
  const showDetails = step !== _page.ANALYTICS_STEPS.VALIDATION && stepActivated === true;
  const {
    dataFrameAnalytics: {
      validateDataFrameAnalytics
    }
  } = (0, _kibana.useMlApi)();
  const dataTestSubj = `mlAnalyticsCreateJobWizardValidationStepWrapper${showValidationStep ? ' active' : ''}${showDetails ? ' summary' : ''}`;
  const debouncedValidationChecks = (0, _lodash.debounce)(async () => {
    setChecksInProgress(true);
    try {
      const analyticsJobConfig = isAdvancedEditorEnabled ? jobConfig : (0, _state.getJobConfigFromFormState)(form);
      const validationResults = await validateDataFrameAnalytics(analyticsJobConfig);
      setValidationMessages(validationResults);
      setErrorMessage(undefined);
      setChecksInProgress(false);
    } catch (err) {
      setErrorMessage({
        heading: _i18n.i18n.translate('xpack.ml.dataframe.analytics.validation.validationFetchErrorMessage', {
          defaultMessage: 'Error validating job'
        }),
        id: 'error',
        status: _mlValidators.VALIDATION_STATUS.ERROR,
        text: (0, _mlErrorUtils.extractErrorMessage)(err)
      });
      setChecksInProgress(false);
    }
  }, 500);
  (0, _react.useEffect)(function beginValidationChecks() {
    if (jobType !== undefined && (showValidationStep || stepActivated === true)) {
      debouncedValidationChecks();
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [showValidationStep, dependentVariable, trainingPercent, numTopFeatureImportanceValues, numTopClasses, includes]);
  if (errorMessage !== undefined) {
    validationMessages.push(errorMessage);
  }
  const validationSummary = (0, _react.useMemo)(() => validationMessages.reduce((acc, message) => {
    if ((message === null || message === void 0 ? void 0 : message.status) === _mlValidators.VALIDATION_STATUS.WARNING) {
      acc.warning += 1;
    } else if ((message === null || message === void 0 ? void 0 : message.status) === _mlValidators.VALIDATION_STATUS.SUCCESS) {
      acc.success += 1;
    }
    return acc;
  }, {
    warning: 0,
    success: 0
  }), [validationMessages]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "mlDataFrameAnalyticsCreateForm",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, showValidationStep && /*#__PURE__*/_react.default.createElement(_validation_step.ValidationStep, {
    checksInProgress: checksInProgress,
    validationMessages: validationMessages,
    setCurrentStep: setCurrentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }), showDetails && /*#__PURE__*/_react.default.createElement(_validation_step_details.ValidationStepDetails, {
    setCurrentStep: setCurrentStep,
    state: state,
    validationSummary: validationSummary,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }));
};
exports.ValidationStepWrapper = ValidationStepWrapper;