"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metrics = void 0;
var _pod_overview = require("./tsvb/pod_overview");
var _pod_cpu_usage = require("./tsvb/pod_cpu_usage");
var _pod_log_usage = require("./tsvb/pod_log_usage");
var _pod_memory_usage = require("./tsvb/pod_memory_usage");
var _pod_network_traffic = require("./tsvb/pod_network_traffic");
var _metrics_catalog = require("../../../shared/metrics/metrics_catalog");
var _required_metrics = require("../../../shared/metrics/required_metrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metrics = exports.metrics = {
  tsvb: {
    podOverview: _pod_overview.podOverview,
    podCpuUsage: _pod_cpu_usage.podCpuUsage,
    podLogUsage: _pod_log_usage.podLogUsage,
    podNetworkTraffic: _pod_network_traffic.podNetworkTraffic,
    podMemoryUsage: _pod_memory_usage.podMemoryUsage
  },
  requiredTsvb: ['podOverview', 'podCpuUsage', 'podMemoryUsage', 'podNetworkTraffic', ..._required_metrics.nginx],
  getAggregations: async () => {
    const {
      snapshot
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./snapshot')));
    const catalog = new _metrics_catalog.MetricsCatalog(snapshot);
    return catalog;
  },
  getWaffleMapTooltipMetrics: () => ['cpu', 'memory', 'rx', 'tx'],
  defaultSnapshot: 'cpu',
  defaultTimeRangeInSeconds: 3600 // 1 hour
};