"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizedLoad1m = exports.load5m = exports.load1m = exports.load15m = exports.cpuUsageUser = exports.cpuUsageSystem = exports.cpuUsageSteal = exports.cpuUsageSoftirq = exports.cpuUsageNice = exports.cpuUsageIrq = exports.cpuUsageIowait = exports.cpuUsage = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cpuUsageIowait = exports.cpuUsageIowait = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.iowaitLabel', {
    defaultMessage: 'iowait'
  }),
  value: {
    ecs: 'average(system.cpu.iowait.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: wait') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsageIrq = exports.cpuUsageIrq = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.irqLabel', {
    defaultMessage: 'irq'
  }),
  value: {
    ecs: 'average(system.cpu.irq.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: interrupt') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsageNice = exports.cpuUsageNice = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.niceLabel', {
    defaultMessage: 'nice'
  }),
  value: {
    ecs: 'average(system.cpu.nice.norm.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: nice') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsageSoftirq = exports.cpuUsageSoftirq = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.softirqLabel', {
    defaultMessage: 'softirq'
  }),
  value: {
    ecs: 'average(system.cpu.softirq.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: softirq') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsageSteal = exports.cpuUsageSteal = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.stealLabel', {
    defaultMessage: 'steal'
  }),
  value: {
    ecs: 'average(system.cpu.steal.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: steal') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsageSystem = exports.cpuUsageSystem = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.systemLabel', {
    defaultMessage: 'system'
  }),
  value: {
    ecs: 'average(system.cpu.system.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: system') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsageUser = exports.cpuUsageUser = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.cpuUsage.userLabel', {
    defaultMessage: 'user'
  }),
  value: {
    ecs: 'average(system.cpu.user.pct) / max(system.cpu.cores)',
    semconv: "average(metrics.system.cpu.utilization,kql='state: user') / max(metrics.system.cpu.logical.count)"
  },
  format: 'percent',
  decimals: 1
};
const cpuUsage = exports.cpuUsage = {
  label: _constants.CPU_USAGE_LABEL,
  value: {
    ecs: 'average(system.cpu.total.norm.pct)',
    semconv: "1-(average(metrics.system.cpu.utilization,kql='state: idle') + average(metrics.system.cpu.utilization,kql='state: wait'))"
  },
  format: 'percent',
  decimals: 0
};
const load1m = exports.load1m = {
  label: _constants.LOAD_1M_LABEL,
  value: {
    ecs: 'average(system.load.1)',
    semconv: 'average(metrics.system.cpu.load_average.1m)'
  },
  format: 'number',
  decimals: 1
};
const load5m = exports.load5m = {
  label: _constants.LOAD_5M_LABEL,
  value: {
    ecs: 'average(system.load.5)',
    semconv: 'average(metrics.system.cpu.load_average.5m)'
  },
  format: 'number',
  decimals: 1
};
const load15m = exports.load15m = {
  label: _constants.LOAD_15M_LABEL,
  value: {
    ecs: 'average(system.load.15)',
    semconv: 'average(metrics.system.cpu.load_average.15m)'
  },
  format: 'number',
  decimals: 1
};
const normalizedLoad1m = exports.normalizedLoad1m = {
  label: _constants.NORMALIZED_LOAD_LABEL,
  value: {
    ecs: 'average(system.load.1) / max(system.load.cores)',
    semconv: 'average(metrics.system.cpu.load_average.1m) / max(metrics.system.cpu.logical.count)'
  },
  format: 'percent',
  decimals: 0
};