"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectToItem = savedObjectToItem;
exports.transformMapIn = transformMapIn;
var _references = require("../../../../common/migrations/references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function savedObjectToItem(savedObject, partial) {
  const {
    references,
    attributes,
    ...rest
  } = savedObject;
  return {
    ...rest,
    attributes: transformMapOut(attributes, references !== null && references !== void 0 ? references : []),
    references: (references !== null && references !== void 0 ? references : []).filter(({
      type
    }) => type === 'tag')
  };
}
function transformMapOut(storedMapState, references) {
  const {
    attributes
  } = (0, _references.injectReferences)({
    attributes: storedMapState,
    references: references !== null && references !== void 0 ? references : []
  });
  // TODO convert stringified JSON to objects
  return attributes;
}
function transformMapIn(mapState) {
  const {
    attributes,
    references
  } = (0, _references.extractReferences)({
    attributes: mapState
  });
  // TODO convert API state to stringified JSON
  return {
    attributes,
    references
  };
}