"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _features_tooltip = require("./features_tooltip");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/tooltip_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const noop = () => {};
class TooltipPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_popoverRef", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "_updatePopoverPosition", () => {
      const nextPoint = this.props.mbMap.project(this.props.location);
      const lat = this.props.location[_constants.LAT_INDEX];
      const lon = this.props.location[_constants.LON_INDEX];
      const bounds = this.props.mbMap.getBounds();
      const isVisible = lat < bounds.getNorth() && lat > bounds.getSouth() && lon > bounds.getWest() && lon < bounds.getEast();
      if (!isVisible) {
        this.props.closeTooltip();
      } else {
        this.setState({
          x: nextPoint.x,
          y: nextPoint.y
        });
      }
    });
    (0, _defineProperty2.default)(this, "_loadFeatureProperties", async ({
      layerId,
      properties
    }) => {
      const tooltipLayer = this.props.findLayerById(layerId);
      if (!tooltipLayer) {
        return [];
      }
      return await tooltipLayer.getPropertiesForTooltip(properties, this.props.executionContext);
    });
    (0, _defineProperty2.default)(this, "_getLayerName", async layerId => {
      const layer = this.props.findLayerById(layerId);
      if (!layer) {
        return null;
      }
      return layer.getDisplayName();
    });
    (0, _defineProperty2.default)(this, "_renderTooltipContent", () => {
      const publicProps = {
        addFilters: this.props.addFilters,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        onSingleValueTrigger: this.props.onSingleValueTrigger,
        closeTooltip: this.props.closeTooltip,
        features: this.props.features,
        isLocked: this.props.isLocked,
        loadFeatureProperties: this._loadFeatureProperties,
        loadFeatureGeometry: this.props.loadFeatureGeometry,
        getLayerName: this._getLayerName
      };
      if (this.props.renderTooltipContent) {
        return this.props.renderTooltipContent(publicProps);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        style: {
          maxWidth: '425px'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_features_tooltip.FeaturesTooltip, (0, _extends2.default)({}, publicProps, {
        findLayerById: this.props.findLayerById,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 9
        }
      })));
    });
  }
  componentDidMount() {
    this._updatePopoverPosition();
    this.props.mbMap.on('move', this._updatePopoverPosition);
  }
  componentDidUpdate() {
    if (this._popoverRef.current) {
      this._popoverRef.current.positionPopoverFluid();
    }
  }
  componentWillUnmount() {
    this.props.mbMap.off('move', this._updatePopoverPosition);
  }
  render() {
    if (this.state.x === undefined || this.state.y === undefined) {
      return null;
    }
    const tooltipAnchor = /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '26px',
        width: '26px',
        background: 'none'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 27
      }
    });
    // Although tooltip anchors are not visible, they take up horizontal space.
    // This horizontal spacing needs to be accounted for in the translate function,
    // otherwise the anchors get increasingly pushed to the right away from the actual location.
    const offset = this.props.index * 26;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "mapTooltip",
      button: tooltipAnchor,
      anchorPosition: "upCenter",
      isOpen: true,
      closePopover: noop,
      ref: this._popoverRef,
      style: {
        pointerEvents: 'none',
        transform: `translate(${this.state.x - 13 - offset}px, ${this.state.y - 13}px)`
      },
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 7
      }
    }, this._renderTooltipContent());
  }
}
exports.TooltipPopover = TooltipPopover;