"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributionFormRow = AttributionFormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _attribution_popover = require("./attribution_popover");
var _panel_strings = require("../../panel_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/layer_settings/attribution_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AttributionFormRow(props) {
  function renderAttribution() {
    const layerDescriptor = props.layer.getDescriptor();
    return /*#__PURE__*/_react.default.createElement("fieldset", {
      "aria-labelledby": "mapsLayerSettingsAttributionLegend",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("legend", {
      id: "mapsLayerSettingsAttributionLegend",
      className: "mapAttributionFormRow__legend",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.maps.layerSettings.attributionLegend', {
      defaultMessage: 'Attribution'
    }))), layerDescriptor.attribution === undefined ? /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow__field",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_attribution_popover.AttributionPopover, {
      onChange: props.onChange,
      popoverButtonIcon: "plusInCircleFilled",
      popoverButtonLabel: _i18n.i18n.translate('xpack.maps.attribution.addBtnLabel', {
        defaultMessage: 'Add attribution'
      }),
      popoverButtonAriaLabel: _i18n.i18n.translate('xpack.maps.attribution.addBtnAriaLabel', {
        defaultMessage: 'Add attribution'
      }),
      popoverButtonClassName: "mapAttributionFormRow__addButton",
      label: '',
      url: '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 15
      }
    })) : /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow__field",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      href: layerDescriptor.attribution.url,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 17
      }
    }, layerDescriptor.attribution.label)), /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow__buttons",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_attribution_popover.AttributionPopover, {
      onChange: props.onChange,
      popoverButtonIcon: "pencil",
      popoverButtonAriaLabel: _i18n.i18n.translate('xpack.maps.attribution.editBtnAriaLabel', {
        defaultMessage: 'Edit attribution'
      }),
      popoverButtonLabel: _panel_strings.panelStrings.edit,
      label: layerDescriptor.attribution.label,
      url: layerDescriptor.attribution.url,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        props.onChange();
      },
      size: "xs",
      iconType: "trash",
      color: "danger",
      "aria-label": _i18n.i18n.translate('xpack.maps.attribution.clearBtnAriaLabel', {
        defaultMessage: 'Clear attribution'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 17
      }
    }, _panel_strings.panelStrings.clear)))));
  }
  return props.layer.getSource().getAttributionProvider() ? null : renderAttribution();
}