"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _kibana_services = require("../../../kibana_services");
var _global_filter_checkbox = require("../../../components/global_filter_checkbox");
var _global_time_checkbox = require("../../../components/global_time_checkbox");
var _es_source = require("../../../classes/sources/es_source");
var _force_refresh_checkbox = require("../../../components/force_refresh_checkbox");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/filter_editor/filter_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FilterEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false,
      isSourceTimeAware: false
    });
    (0, _defineProperty2.default)(this, "_toggle", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_close", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onQueryChange", ({
      query
    }) => {
      if (!query) {
        return;
      }
      this.props.setLayerQuery(this.props.layer.getId(), query);
      this._close();
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalQueryChange", applyGlobalQuery => {
      this.props.updateSourceProp(this.props.layer.getId(), 'applyGlobalQuery', applyGlobalQuery);
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalTimeChange", applyGlobalTime => {
      this.props.updateSourceProp(this.props.layer.getId(), 'applyGlobalTime', applyGlobalTime);
    });
    (0, _defineProperty2.default)(this, "_onRespondToForceRefreshChange", applyForceRefresh => {
      this.props.updateSourceProp(this.props.layer.getId(), 'applyForceRefresh', applyForceRefresh);
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadDataView();
    this._loadSourceTimeAware();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadDataView() {
    const source = this.props.layer.getSource();
    if (!(0, _es_source.hasESSourceMethod)(source, 'getIndexPattern')) {
      return;
    }
    const dataView = await source.getIndexPattern();
    if (!this._isMounted) {
      return;
    }
    this.setState({
      dataView
    });
  }
  async _loadSourceTimeAware() {
    const isSourceTimeAware = await this.props.layer.getSource().isTimeAware();
    if (this._isMounted) {
      this.setState({
        isSourceTimeAware
      });
    }
  }
  _renderQueryPopover() {
    const layerQuery = this.props.layer.getQuery();
    const SearchBar = (0, _kibana_services.getSearchBar)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "layerQueryPopover",
      button: this._renderOpenButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._close,
      anchorPosition: "leftCenter",
      ownFocus: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapFilterEditor",
      "data-test-subj": "mapFilterEditor",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(SearchBar, {
      appName: _constants.APP_ID,
      showFilterBar: false,
      showDatePicker: false,
      showQueryInput: true,
      query: layerQuery ? layerQuery : (0, _kibana_services.getData)().query.queryString.getDefaultQuery(),
      onQuerySubmit: this._onQueryChange,
      indexPatterns: this.state.dataView ? [this.state.dataView] : [],
      customSubmitButton: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "mapFilterEditorSubmitButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.filterEditor.queryBarSubmitButtonLabel",
        defaultMessage: "Set filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 17
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    })));
  }
  _renderQuery() {
    if (this.props.isFeatureEditorOpenForLayer) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.filterEditor.isLayerFilterNotApplied",
        defaultMessage: "Layer filter is not applied while editing features",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 9
        }
      });
    }
    const query = this.props.layer.getQuery();
    if (!query || !query.query) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.filterEditor.emptyState.description",
        defaultMessage: "Add a filter to narrow the layer data.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    }, query.query), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }));
  }
  _renderOpenButton() {
    const query = this.props.layer.getQuery();
    const openButtonLabel = query && query.query ? _i18n.i18n.translate('xpack.maps.layerPanel.filterEditor.editFilterButtonLabel', {
      defaultMessage: 'Edit filter'
    }) : _i18n.i18n.translate('xpack.maps.layerPanel.filterEditor.addFilterButtonLabel', {
      defaultMessage: 'Set filter'
    });
    const openButtonIcon = query && query.query ? 'pencil' : 'plusInCircleFilled';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: this._toggle,
      "data-test-subj": "mapLayerPanelOpenFilterEditorButton",
      iconType: openButtonIcon,
      disabled: this.props.isFeatureEditorOpenForLayer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 7
      }
    }, openButtonLabel);
  }
  render() {
    const globalTimeCheckbox = this.state.isSourceTimeAware ? /*#__PURE__*/_react.default.createElement(_global_time_checkbox.GlobalTimeCheckbox, {
      label: _i18n.i18n.translate('xpack.maps.filterEditor.applyGlobalTimeCheckboxLabel', {
        defaultMessage: `Apply global time to layer data`
      }),
      applyGlobalTime: this.props.layer.getSource().getApplyGlobalTime(),
      setApplyGlobalTime: this._onApplyGlobalTimeChange,
      isFeatureEditorOpenForLayer: this.props.isFeatureEditorOpenForLayer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 7
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.filterEditor.title",
      defaultMessage: "Filtering",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: 'row',
      wrap: false,
      component: 'span',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 11
      }
    }, this._renderQueryPopover()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 6,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 11
      }
    }, this._renderQuery())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "full",
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_global_filter_checkbox.GlobalFilterCheckbox, {
      label: _i18n.i18n.translate('xpack.maps.filterEditor.applyGlobalQueryCheckboxLabel', {
        defaultMessage: `Apply global search to layer data`
      }),
      applyGlobalQuery: this.props.layer.getSource().getApplyGlobalQuery(),
      setApplyGlobalQuery: this._onApplyGlobalQueryChange,
      isFeatureEditorOpenForLayer: this.props.isFeatureEditorOpenForLayer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 9
      }
    }), globalTimeCheckbox, /*#__PURE__*/_react.default.createElement(_force_refresh_checkbox.ForceRefreshCheckbox, {
      applyForceRefresh: this.props.layer.getSource().getApplyForceRefresh(),
      setApplyForceRefresh: this._onRespondToForceRefreshChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 9
      }
    }));
  }
}
exports.FilterEditor = FilterEditor;