"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _symbol_icon = require("../legend/symbol_icon");
var _symbol_utils = require("../../symbol_utils");
var _kibana_services = require("../../../../../kibana_services");
var _custom_icon_modal = require("./custom_icon_modal");
var _prepend_button = require("./prepend_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/symbol/icon_select.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isKeyboardEvent(event) {
  return typeof event === 'object' && 'keyCode' in event;
}
class IconSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false,
      isModalVisible: false
    });
    (0, _defineProperty2.default)(this, "_handleSave", ({
      symbolId,
      svg,
      cutoff,
      radius,
      label
    }) => {
      const icons = [...this.props.customIcons.filter(i => {
        return i.symbolId !== symbolId;
      }), {
        symbolId,
        svg,
        label,
        cutoff,
        radius
      }];
      this.props.onCustomIconsChange(icons);
      this._hideModal();
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_hideModal", () => {
      this.setState({
        isModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "_openPopover", () => {
      this.setState({
        isPopoverOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "_showModal", () => {
      this.setState({
        isModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "_toggleModal", () => {
      this.setState(prevState => ({
        isModalVisible: !prevState.isModalVisible
      }));
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_handleKeyboardActivity", e => {
      if (isKeyboardEvent(e)) {
        if (e.key === _eui.keys.ENTER) {
          e.preventDefault();
          this._togglePopover();
        } else if (e.key === _eui.keys.ARROW_DOWN) {
          this._openPopover();
        }
      }
    });
    (0, _defineProperty2.default)(this, "_onIconSelect", options => {
      const selectedOption = options.find(option => {
        return option.checked === 'on';
      });
      if (selectedOption) {
        const {
          key
        } = selectedOption;
        this.props.onChange({
          selectedIconId: key
        });
      }
      this._closePopover();
    });
  }
  _renderPopoverButton() {
    const {
      value,
      svg,
      label
    } = this.props.icon;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      icon: {
        type: 'arrowDown',
        side: 'right'
      },
      onClick: this._togglePopover,
      onKeyDown: this._handleKeyboardActivity,
      value: label || value,
      compressed: true,
      readOnly: true,
      fullWidth: true,
      prepend: /*#__PURE__*/_react.default.createElement(_prepend_button.PrependButton, {
        value: value,
        svg: svg,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 18
        }
      }),
      append: this.props.append,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    });
  }
  _renderIconSelectable() {
    const makiOptions = [{
      label: _i18n.i18n.translate('xpack.maps.styles.vector.iconSelect.kibanaIconsGroupLabel', {
        defaultMessage: 'Kibana icons'
      }),
      isGroupLabel: true
    }, ..._symbol_utils.SYMBOL_OPTIONS.map(({
      value,
      label,
      svg
    }) => {
      return {
        key: value,
        label,
        prepend: /*#__PURE__*/_react.default.createElement(_symbol_icon.SymbolIcon, {
          key: value,
          symbolId: value,
          fill: (0, _kibana_services.getIsDarkMode)() ? 'rgb(223, 229, 239)' : 'rgb(52, 55, 65)',
          svg: svg,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 13
          }
        })
      };
    })];
    const customOptions = this.props.customIcons.map(({
      symbolId,
      label,
      svg
    }) => {
      return {
        key: symbolId,
        label,
        prepend: /*#__PURE__*/_react.default.createElement(_symbol_icon.SymbolIcon, {
          key: symbolId,
          symbolId: symbolId,
          svg: svg,
          fill: (0, _kibana_services.getIsDarkMode)() ? 'rgb(223, 229, 239)' : 'rgb(52, 55, 65)',
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 11
          }
        })
      };
    });
    if (customOptions.length) customOptions.splice(0, 0, {
      label: _i18n.i18n.translate('xpack.maps.styles.vector.iconSelect.customIconsGroupLabel', {
        defaultMessage: 'Custom icons'
      }),
      isGroupLabel: true
    });
    const options = [...customOptions, ...makiOptions];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
      searchable: true,
      options: options,
      onChange: this._onIconSelect,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 7
      }
    }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '300px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }, search), list, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: true,
      size: "s",
      onClick: this._toggleModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.styles.vector.iconSelect.addCustomIconButtonLabel",
      defaultMessage: "Add custom icon",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 17
      }
    })))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      ownFocus: true,
      button: this._renderPopoverButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      anchorPosition: "downLeft",
      panelPaddingSize: "s",
      display: "block",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
      clickOutsideDisables: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 11
      }
    }, this._renderIconSelectable())), this.state.isModalVisible ? /*#__PURE__*/_react.default.createElement(_custom_icon_modal.CustomIconModal, {
      title: "Add custom Icon",
      cutoff: _constants.DEFAULT_CUSTOM_ICON_CUTOFF,
      radius: _constants.DEFAULT_CUSTOM_ICON_RADIUS,
      onSave: this._handleSave,
      onCancel: this._hideModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 11
      }
    }) : null);
  }
}
exports.IconSelect = IconSelect;