"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WMSCreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _wms_client = require("./wms_client");
var _lodash = _interopRequireDefault(require("lodash"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/wms_source/wms_create_source_editor.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LAYERS_LABEL = _i18n.i18n.translate('xpack.maps.source.wms.layersLabel', {
  defaultMessage: 'Layers'
});
const STYLES_LABEL = _i18n.i18n.translate('xpack.maps.source.wms.stylesLabel', {
  defaultMessage: 'Styles'
});
class WMSCreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      serviceUrl: '',
      layers: '',
      styles: '',
      isLoadingCapabilities: false,
      getCapabilitiesError: null,
      hasAttemptedToLoadCapabilities: false,
      layerOptions: [],
      styleOptions: [],
      selectedLayerOptions: [],
      selectedStyleOptions: []
    });
    (0, _defineProperty2.default)(this, "_previewIfPossible", _lodash.default.debounce(() => {
      const {
        serviceUrl,
        layers,
        styles
      } = this.state;
      const sourceConfig = serviceUrl && layers ? {
        serviceUrl,
        layers,
        styles
      } : null;
      this.props.onSourceConfigChange(sourceConfig);
    }, 2000));
    (0, _defineProperty2.default)(this, "_loadCapabilities", async () => {
      if (!this.state.serviceUrl) {
        return;
      }
      this.setState({
        hasAttemptedToLoadCapabilities: true,
        isLoadingCapabilities: true,
        getCapabilitiesError: null
      });
      const wmsClient = new _wms_client.WmsClient({
        serviceUrl: this.state.serviceUrl
      });
      let capabilities;
      try {
        capabilities = await wmsClient.getCapabilities();
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            isLoadingCapabilities: false,
            getCapabilitiesError: error.message
          });
        }
        return;
      }
      if (!this._isMounted) {
        return;
      }
      this.setState({
        isLoadingCapabilities: false,
        layerOptions: capabilities.layers,
        styleOptions: capabilities.styles
      });
    });
    (0, _defineProperty2.default)(this, "_handleServiceUrlChange", e => {
      this.setState({
        serviceUrl: e.target.value,
        hasAttemptedToLoadCapabilities: false,
        layerOptions: [],
        styleOptions: [],
        selectedLayerOptions: [],
        selectedStyleOptions: [],
        layers: '',
        styles: ''
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleLayersChange", e => {
      this.setState({
        layers: e.target.value
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleLayerOptionsChange", selectedOptions => {
      this.setState({
        selectedLayerOptions: selectedOptions,
        layers: selectedOptions.map(selectedOption => {
          return selectedOption.value;
        }).join(',')
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleStylesChange", e => {
      this.setState({
        styles: e.target.value
      }, this._previewIfPossible);
    });
    (0, _defineProperty2.default)(this, "_handleStyleOptionsChange", selectedOptions => {
      this.setState({
        selectedStyleOptions: selectedOptions,
        styles: selectedOptions.map(selectedOption => {
          return selectedOption.value;
        }).join(',')
      }, this._previewIfPossible);
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  _renderLayerAndStyleInputs() {
    if (!this.state.hasAttemptedToLoadCapabilities || this.state.isLoadingCapabilities) {
      return null;
    }
    if (this.state.getCapabilitiesError || this.state.layerOptions.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.maps.source.wms.getCapabilitiesErrorCalloutTitle', {
          defaultMessage: 'Unable to load service metadata'
        }),
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 13
        }
      }, this.state.getCapabilitiesError)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: LAYERS_LABEL,
        helpText: _i18n.i18n.translate('xpack.maps.source.wms.layersHelpText', {
          defaultMessage: 'Use comma separated list of layer names'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        onChange: this._handleLayersChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: STYLES_LABEL,
        helpText: _i18n.i18n.translate('xpack.maps.source.wms.stylesHelpText', {
          defaultMessage: 'Use comma separated list of style names'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        onChange: this._handleStylesChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: LAYERS_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: this.state.layerOptions,
      selectedOptions: this.state.selectedLayerOptions,
      onChange: this._handleLayerOptionsChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: STYLES_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: this.state.styleOptions,
      selectedOptions: this.state.selectedStyleOptions,
      onChange: this._handleStyleOptionsChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 11
      }
    })));
  }
  _renderGetCapabilitiesButton() {
    if (!this.state.isLoadingCapabilities && this.state.hasAttemptedToLoadCapabilities) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this._loadCapabilities,
      isDisabled: !this.state.serviceUrl,
      isLoading: this.state.isLoadingCapabilities,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.wms.getCapabilitiesButtonText",
      defaultMessage: "Load capabilities",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 11
      }
    })));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.wms.urlLabel', {
        defaultMessage: 'Url'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.serviceUrl,
      onChange: this._handleServiceUrlChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 11
      }
    })), this._renderGetCapabilitiesButton(), this._renderLayerAndStyleInputs());
  }
}
exports.WMSCreateSourceEditor = WMSCreateSourceEditor;