"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractVectorSource = void 0;
exports.hasVectorSourceMethod = hasVectorSourceMethod;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _tooltip_property = require("../../tooltips/tooltip_property");
var _source = require("../source");
var _features_tooltip = require("../../../connected_components/mb_map/tooltip_control/features_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/vector_source/vector_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function hasVectorSourceMethod(source, methodName) {
  return typeof source[methodName] === 'function';
}
class AbstractVectorSource extends _source.AbstractSource {
  isMvt() {
    return false;
  }
  isFilterByMapBounds() {
    return false;
  }
  isBoundsAware() {
    return false;
  }
  async supportsFitToBounds() {
    return true;
  }
  async getBoundsForFilters(boundsFilters, registerCancelCallback) {
    return null;
  }
  async getFields() {
    return [];
  }
  getFieldByName(fieldName) {
    throw new Error('Must implement VectorSource#getFieldByName');
  }
  async getLeftJoinFields() {
    return [];
  }
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    throw new Error('Should implement VectorSource#getGeoJsonWithMeta');
  }
  hasTooltipProperties() {
    return false;
  }

  // Allow source to filter and format feature properties before displaying to user
  async getTooltipProperties(properties, executionContext) {
    const tooltipProperties = [];
    for (const key in properties) {
      if (key.startsWith('__kbn')) {
        // these are system properties and should be ignored
        continue;
      }
      tooltipProperties.push(new _tooltip_property.TooltipProperty(key, key, properties[key]));
    }
    return tooltipProperties;
  }
  async isTimeAware() {
    return false;
  }
  supportsJoins() {
    return true;
  }
  async getSupportedShapeTypes() {
    return [_constants.VECTOR_SHAPE_TYPE.POINT, _constants.VECTOR_SHAPE_TYPE.LINE, _constants.VECTOR_SHAPE_TYPE.POLYGON];
  }
  getSourceStatus(sourceDataRequest) {
    return {
      tooltipContent: null,
      areResultsTrimmed: false
    };
  }
  getSyncMeta(dataFilters) {
    return null;
  }
  async getTimesliceMaskFieldName() {
    return null;
  }
  async addFeature(geometry) {
    throw new Error('Should implement VectorSource#addFeature');
  }
  async deleteFeature(featureId) {
    throw new Error('Should implement VectorSource#deleteFeature');
  }
  async supportsFeatureEditing() {
    return false;
  }
  getFeatureActions({
    addFilters,
    geoFieldNames,
    getActionContext,
    getFilterActions,
    getGeojsonGeometry,
    mbFeature,
    onClose
  }) {
    if (geoFieldNames.length === 0 || addFilters === null) {
      return [];
    }
    const isPolygon = mbFeature.geometry.type === _constants.GEO_JSON_TYPE.POLYGON || mbFeature.geometry.type === _constants.GEO_JSON_TYPE.MULTI_POLYGON;
    if (!isPolygon) {
      return [];
    }
    if (this.isMvt()) {
      // It is not possible to filter by geometry for vector tiles because there is no way to get original geometry
      // mbFeature.geometry may not be the original geometry, it has been simplified and trimmed to tile bounds
      return [];
    }
    const geojsonGeometry = getGeojsonGeometry();
    return geojsonGeometry ? [{
      label: _i18n.i18n.translate('xpack.maps.tooltip.action.filterByGeometryLabel', {
        defaultMessage: 'Filter by geometry'
      }),
      id: 'FILTER_BY_GEOMETRY_ACTION',
      form: /*#__PURE__*/_react.default.createElement(_features_tooltip.FeatureGeometryFilterForm, {
        onClose: onClose,
        geoFieldNames: geoFieldNames,
        addFilters: addFilters,
        getFilterActions: getFilterActions,
        getActionContext: getActionContext,
        geometry: geojsonGeometry,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 15
        }
      })
    }] : [];
  }
  getInspectorRequestIds() {
    return [];
  }
}
exports.AbstractVectorSource = AbstractVectorSource;