"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoLineForm = GeoLineForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _single_field_select = require("../../../../components/single_field_select");
var _index_pattern_util = require("../../../../index_pattern_util");
var _i18n_constants = require("./i18n_constants");
var _group_by_button_group = require("./group_by_button_group");
var _group_by_label = require("./group_by_label");
var _size_slider = require("./size_slider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_line_source/geo_line_form/geo_line_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GeoLineForm(props) {
  const isTimeseries = (0, _react.useMemo)(() => {
    return (0, _index_pattern_util.getIsTimeseries)(props.indexPattern);
  }, [props.indexPattern]);
  function onSortFieldChange(fieldName) {
    if (fieldName !== undefined) {
      props.onSortFieldChange(fieldName);
    }
  }
  function onSplitFieldChange(fieldName) {
    if (fieldName !== undefined) {
      props.onSplitFieldChange(fieldName);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isTimeseries && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_group_by_label.GroupByLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 18
      }
    }),
    display: props.isColumnCompressed ? 'columnCompressed' : 'row',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_group_by_button_group.GroupByButtonGroup, {
    groupByTimeseries: props.groupByTimeseries,
    onGroupByTimeseriesChange: props.onGroupByTimeseriesChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  })), props.groupByTimeseries ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.esGeoLine.lineSImplificationSizeLabel', {
      defaultMessage: 'Simplification threshold'
    }),
    helpText: _i18n.i18n.translate('xpack.maps.esGeoLine.lineSImplificationSizeHelpText', {
      defaultMessage: 'The maximum number of points for each track. Track is simplifed when threshold is exceeded. Use smaller values for better performance.'
    }),
    display: props.isColumnCompressed ? 'columnCompressed' : 'row',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_size_slider.SizeSlider, {
    value: props.lineSimplificationSize,
    onChange: props.onLineSimplificationSizeChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_constants.ENTITY_INPUT_LABEL,
    display: props.isColumnCompressed ? 'columnCompressed' : 'row',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoLine.splitFieldPlaceholder', {
      defaultMessage: 'Select entity field'
    }),
    value: props.splitField,
    onChange: onSplitFieldChange,
    fields: (0, _index_pattern_util.getTermsFields)(props.indexPattern.fields),
    isClearable: false,
    compressed: props.isColumnCompressed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_constants.SORT_INPUT_LABEL,
    display: props.isColumnCompressed ? 'columnCompressed' : 'row',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoLine.sortFieldPlaceholder', {
      defaultMessage: 'Select sort field'
    }),
    value: props.sortField,
    onChange: onSortFieldChange,
    fields: props.indexPattern.fields.filter(field => {
      const isSplitField = props.splitField ? field.name === props.splitField : false;
      return !isSplitField && field.sortable && !_public.indexPatterns.isNestedField(field) && ['number', 'date'].includes(field.type);
    }),
    isClearable: false,
    compressed: props.isColumnCompressed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }))));
}