"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emsBaseMapLayerWizardConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ems_tms_source = require("./ems_tms_source");
var _ems_vector_tile_layer = require("../../layers/ems_vector_tile_layer/ems_vector_tile_layer");
var _create_source_editor = require("./create_source_editor");
var _kibana_services = require("../../../kibana_services");
var _constants = require("../../../../common/constants");
var _world_map_layer_icon = require("../../layers/wizards/icons/world_map_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/ems_tms_source/ems_base_map_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getDescription() {
  const emsSettings = (0, _kibana_services.getEMSSettings)();
  return _i18n.i18n.translate('xpack.maps.source.emsTileSourceDescription', {
    defaultMessage: 'Basemap service from {host}',
    values: {
      host: emsSettings.isEMSUrlSet() ? emsSettings.getEMSRoot() : 'Elastic Maps Service'
    }
  });
}
const emsBaseMapLayerWizardConfig = exports.emsBaseMapLayerWizardConfig = {
  id: _constants.WIZARD_ID.EMS_BASEMAP,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.REFERENCE],
  checkVisibility: async () => {
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    return emsSettings.isIncludeElasticMapsService();
  },
  description: getDescription(),
  disabledReason: _i18n.i18n.translate('xpack.maps.source.emsTileDisabledReason', {
    defaultMessage: 'Elastic Maps Server requires an Enterprise license'
  }),
  getIsDisabled: () => {
    const emsSettings = (0, _kibana_services.getEMSSettings)();
    return emsSettings.isEMSUrlSet() && !emsSettings.hasOnPremLicense();
  },
  icon: _world_map_layer_icon.WorldMapLayerIcon,
  renderWizard: ({
    previewLayers
  }) => {
    const onSourceConfigChange = sourceConfig => {
      const layerDescriptor = _ems_vector_tile_layer.EmsVectorTileLayer.createDescriptor({
        sourceDescriptor: _ems_tms_source.EMSTMSSource.createDescriptor(sourceConfig)
      });
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      onTileSelect: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  },
  title: (0, _ems_tms_source.getSourceTitle)()
};