"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPLOAD_STEPS = exports.ClientFileCreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _geojson_file_source = require("../../../sources/geojson_file_source");
var _vector_layer = require("../../vector_layer");
var _es_search_source = require("../../../sources/es_search_source");
var _kibana_services = require("../../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/file_upload_wizard/wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let UPLOAD_STEPS = exports.UPLOAD_STEPS = /*#__PURE__*/function (UPLOAD_STEPS) {
  UPLOAD_STEPS["CONFIGURE_UPLOAD"] = "CONFIGURE_UPLOAD";
  UPLOAD_STEPS["UPLOAD"] = "UPLOAD";
  UPLOAD_STEPS["ADD_DOCUMENT_LAYER"] = "ADD_DOCUMENT_LAYER";
  return UPLOAD_STEPS;
}({});
var INDEXING_STAGE = /*#__PURE__*/function (INDEXING_STAGE) {
  INDEXING_STAGE["CONFIGURE"] = "CONFIGURE";
  INDEXING_STAGE["TRIGGERED"] = "TRIGGERED";
  INDEXING_STAGE["SUCCESS"] = "SUCCESS";
  INDEXING_STAGE["ERROR"] = "ERROR";
  return INDEXING_STAGE;
}(INDEXING_STAGE || {});
class ClientFileCreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      indexingStage: INDEXING_STAGE.CONFIGURE
    });
    (0, _defineProperty2.default)(this, "_addDocumentLayer", _lodash.default.once(results => {
      const esSearchSourceConfig = {
        indexPatternId: results.indexPatternId,
        geoField: results.geoFieldName,
        scalingType: _constants.SCALING_TYPES.MVT
      };
      this.props.previewLayers([(0, _es_search_source.createDefaultLayerDescriptor)(esSearchSourceConfig, this.props.mapColors)]);
      this.props.advanceToNextStep();
    }));
    (0, _defineProperty2.default)(this, "_onFileSelect", (geojsonFile, name, previewCoverage) => {
      if (!this._isMounted) {
        return;
      }
      if (!geojsonFile) {
        this.props.previewLayers([]);
        return;
      }
      const areResultsTrimmed = previewCoverage < 100;
      const sourceDescriptor = _geojson_file_source.GeoJsonFileSource.createDescriptor({
        __featureCollection: geojsonFile,
        areResultsTrimmed,
        tooltipContent: areResultsTrimmed ? _i18n.i18n.translate('xpack.maps.fileUpload.trimmedResultsMsg', {
          defaultMessage: `Results limited to {numFeatures} features, {previewCoverage}% of file.`,
          values: {
            numFeatures: geojsonFile.features.length.toLocaleString(),
            previewCoverage
          }
        }) : null,
        name
      });
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor
      }, this.props.mapColors);
      this.props.previewLayers([layerDescriptor]);
    });
    (0, _defineProperty2.default)(this, "_onFileClear", () => {
      this.props.previewLayers([]);
    });
    (0, _defineProperty2.default)(this, "_onUploadComplete", results => {
      if (!this._isMounted) {
        return;
      }
      this.setState({
        results
      });
      this.setState({
        indexingStage: INDEXING_STAGE.SUCCESS
      });
      this.props.advanceToNextStep();
      this.props.enableNextBtn();
    });
    (0, _defineProperty2.default)(this, "_onUploadError", () => {
      if (!this._isMounted) {
        return;
      }
      this.props.stopStepLoading();
      this.props.disableNextBtn();
      this.setState({
        indexingStage: INDEXING_STAGE.ERROR
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    if (this.props.currentStepId === UPLOAD_STEPS.UPLOAD && this.state.indexingStage === INDEXING_STAGE.CONFIGURE) {
      this.setState({
        indexingStage: INDEXING_STAGE.TRIGGERED
      });
      this.props.startStepLoading();
      return;
    }
    if (this.props.isOnFinalStep && this.state.indexingStage === INDEXING_STAGE.SUCCESS && this.state.results) {
      this._addDocumentLayer(this.state.results);
    }
  }
  render() {
    const FileUpload = (0, _kibana_services.getFileUploadComponent)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FileUpload, {
      isIndexingTriggered: this.state.indexingStage === INDEXING_STAGE.TRIGGERED,
      onFileSelect: this._onFileSelect,
      onFileClear: this._onFileClear,
      enableImportBtn: this.props.enableNextBtn,
      disableImportBtn: this.props.disableNextBtn,
      onUploadComplete: this._onUploadComplete,
      onUploadError: this._onUploadError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }));
  }
}
exports.ClientFileCreateSourceEditor = ClientFileCreateSourceEditor;