"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _management_context = require("./management_context");
var _utils = require("../../utils");
var _management_router = require("./management_router");
var _management_sidebar_nav = require("../management_sidebar_nav/management_sidebar_nav");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/management/public/components/management_app/management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManagementApp = ({
  dependencies,
  history,
  appBasePath
}) => {
  const {
    coreStart,
    setBreadcrumbs,
    isSidebarEnabled$,
    cardsNavigationConfig$,
    chromeStyle$
  } = dependencies;
  const [selectedId, setSelectedId] = (0, _react.useState)('');
  const [sections, setSections] = (0, _react.useState)();
  const isSidebarEnabled = (0, _useObservable.default)(isSidebarEnabled$);
  const cardsNavigationConfig = (0, _useObservable.default)(cardsNavigationConfig$);
  const chromeStyle = (0, _useObservable.default)(chromeStyle$);
  const onAppMounted = (0, _react.useCallback)(id => {
    setSelectedId(id);
    window.scrollTo(0, 0);
  }, []);
  const setBreadcrumbsScoped = (0, _react.useCallback)((crumbs = [], appHistory) => {
    const wrapBreadcrumb = (item, scopedHistory) => ({
      ...item,
      ...(item.href ? (0, _public.reactRouterNavigate)(scopedHistory, item.href) : {})
    });

    // Clicking the Management breadcrumb to navigate back to the "root" only
    // makes sense if there's a management app open. So when one isn't open
    // this breadcrumb shouldn't be a clickable link.
    const managementBreadcrumb = crumbs.length ? _utils.MANAGEMENT_BREADCRUMB : _utils.MANAGEMENT_BREADCRUMB_NO_HREF;
    setBreadcrumbs([wrapBreadcrumb(managementBreadcrumb, history), ...crumbs.map(item => wrapBreadcrumb(item, appHistory || history))]);
  }, [setBreadcrumbs, history]);
  (0, _react.useEffect)(() => {
    setSections(dependencies.sections.getSectionsEnabled());
  }, [dependencies.sections]);
  if (!sections) {
    return null;
  }
  const solution = isSidebarEnabled ? {
    name: _i18n.i18n.translate('management.nav.label', {
      defaultMessage: 'Management'
    }),
    icon: 'managementApp',
    'data-test-subj': 'mgtSideBarNav',
    items: (0, _management_sidebar_nav.managementSidebarNav)({
      selectedId,
      sections,
      history
    })
  } : undefined;
  const contextDependencies = {
    appBasePath,
    sections,
    cardsNavigationConfig,
    kibanaVersion: dependencies.kibanaVersion,
    coreStart,
    chromeStyle,
    cloud: dependencies.cloud,
    hasEnterpriseLicense: dependencies.hasEnterpriseLicense
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: dependencies.coreStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_management_context.AppContextProvider, {
    value: contextDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    solutionNav: solution
    // @ts-expect-error Techincally `paddingSize` isn't supported but it is passed through,
    // this is a stop-gap for Stack managmement specifically until page components can be converted to template components
    ,
    mainProps: {
      paddingSize: 'l'
    },
    panelled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_management_router.ManagementRouter, {
    history: history,
    theme: coreStart.theme,
    setBreadcrumbs: setBreadcrumbsScoped,
    onAppMounted: onAppMounted,
    sections: sections,
    analytics: coreStart.analytics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  })))));
};
exports.ManagementApp = ManagementApp;