"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/management/public/components/landing/solution_empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const RulesLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'insightsAndAlerting/triggersActions'
  }),
  "data-test-subj": "managementLinkToRules",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 3
  }
}, _i18n.i18n.translate('management.landing.subhead.rulesLink', {
  defaultMessage: 'rules'
}));
const SavedObjectsLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'kibana/objects'
  }),
  "data-test-subj": "managementLinkToSavedObjects",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 3
  }
}, _i18n.i18n.translate('management.landing.subhead.savedObjectsLink', {
  defaultMessage: 'saved objects'
}));
const UsersLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'security/users'
  }),
  "data-test-subj": "managementLinkToUsers",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 3
  }
}, _i18n.i18n.translate('management.landing.subhead.usersLink', {
  defaultMessage: 'users'
}));
const SolutionEmptyPrompt = ({
  kibanaVersion,
  coreStart
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    "data-test-subj": "managementHomeSolution",
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.solution.header",
      defaultMessage: "Stack Management {version}",
      values: {
        version: kibanaVersion
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.solution.subhead",
      defaultMessage: "Manage your {rulesLink}, {usersLink}, {savedObjectsLink} and more.",
      values: {
        rulesLink: /*#__PURE__*/_react.default.createElement(RulesLink, {
          coreStart: coreStart,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 28
          }
        }),
        usersLink: /*#__PURE__*/_react.default.createElement(UsersLink, {
          coreStart: coreStart,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 28
          }
        }),
        savedObjectsLink: /*#__PURE__*/_react.default.createElement(SavedObjectsLink, {
          coreStart: coreStart,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 35
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.text",
      defaultMessage: "A complete list of apps is in the menu on the left.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
};
exports.SolutionEmptyPrompt = SolutionEmptyPrompt;