"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartTrial = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _telemetry_opt_in = require("../../../components/telemetry_opt_in");
var _constants = require("../../../../../common/constants");
var _app_context = require("../../../app_context");
var _telemetry = require("../../../lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/license_management/public/application/sections/license_dashboard/start_trial/start_trial.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  // EUITODO: Fix modal width/max-width
  licManagementModal: (0, _react2.css)`
    width: 70vw;
  `,
  licManagementIeFlex: (0, _react2.css)`
    flex-shrink: 0;
  `
};
class StartTrial extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "cancelRef", void 0);
    (0, _defineProperty2.default)(this, "confirmRef", void 0);
    (0, _defineProperty2.default)(this, "state", {
      showConfirmation: false,
      isOptingInToTelemetry: false
    });
    (0, _defineProperty2.default)(this, "onOptInChange", isOptingInToTelemetry => {
      this.setState({
        isOptingInToTelemetry
      });
    });
    (0, _defineProperty2.default)(this, "onStartLicenseTrial", () => {
      const {
        telemetry,
        startLicenseTrial
      } = this.props;
      if (this.state.isOptingInToTelemetry && telemetry) {
        telemetry.telemetryService.setOptIn(true);
      }
      startLicenseTrial();
    });
    (0, _defineProperty2.default)(this, "cancel", () => {
      this.setState({
        showConfirmation: false
      });
    });
  }
  UNSAFE_componentWillMount() {
    this.props.loadTrialStatus();
  }
  acknowledgeModal(docLinks) {
    const {
      showConfirmation,
      isOptingInToTelemetry
    } = this.state;
    const {
      telemetry
    } = this.props;
    if (!showConfirmation) {
      return null;
    }
    const modalTitleId = (0, _eui.htmlIdGenerator)()('modalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      css: styles.licManagementModal,
      onClose: this.cancel,
      "aria-labelledby": modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      "data-test-subj": "confirmModalTitleText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalTitle",
      defaultMessage: "Start your free 30-day trial",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "confirmModalBodyText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription",
      defaultMessage: "This trial is for the full set of {subscriptionFeaturesLinkText} of the Elastic Stack. You'll get immediate access to:",
      values: {
        subscriptionFeaturesLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.SUBSCRIPTIONS,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.subscriptionFeaturesLinkText",
          defaultMessage: "subscription features",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 27
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.mashingLearningFeatureTitle",
      defaultMessage: "Machine learning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.alertingFeatureTitle",
      defaultMessage: "Alerting",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.graphCapabilitiesFeatureTitle",
      defaultMessage: "Graph capabilities",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.dataBaseConnectivityFeatureTitle",
      defaultMessage: "{jdbcStandard} and {odbcStandard} connectivity for {sqlDataBase}",
      values: {
        jdbcStandard: 'JDBC',
        odbcStandard: 'ODBC',
        sqlDataBase: 'SQL'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.securityFeaturesConfigurationDescription",
      defaultMessage: "Advanced security features, such as authentication ({authenticationTypeList}), field- and document-level security, and auditing, require configuration. See the {securityDocumentationLinkText} for instructions.",
      values: {
        authenticationTypeList: 'AD/LDAP, SAML, PKI, SAML/SSO',
        securityDocumentationLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.security,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.securityDocumentationLinkText",
          defaultMessage: "documentation",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 171,
            columnNumber: 27
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.termsAndConditionsDescription",
      defaultMessage: "By starting this trial, you agree that it is subject to these {termsAndConditionsLinkText}.",
      values: {
        termsAndConditionsLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.TRIAL_LICENSE,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.termsAndConditionsLinkText",
          defaultMessage: "terms and conditions",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 187,
            columnNumber: 27
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 19
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 13
      }
    }, (0, _telemetry.shouldShowTelemetryOptIn)(telemetry) && /*#__PURE__*/_react.default.createElement(_telemetry_opt_in.TelemetryOptIn, {
      telemetry: telemetry,
      isStartTrial: true,
      onOptInChange: this.onOptInChange,
      isOptingInToTelemetry: isOptingInToTelemetry,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: styles.licManagementIeFlex,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: styles.licManagementIeFlex,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "confirmModalCancelButton",
      onClick: this.cancel,
      buttonRef: this.cancelRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: styles.licManagementIeFlex,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "confirmModalConfirmButton",
      onClick: this.onStartLicenseTrial,
      fill: true,
      buttonRef: this.confirmRef,
      color: "primary",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModal.startTrialButtonLabel",
      defaultMessage: "Start my trial",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 21
      }
    }))))))));
  }
  render() {
    const {
      shouldShowStartTrial
    } = this.props;
    if (!shouldShowStartTrial) {
      return null;
    }
    const description = /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.subscriptionFeaturesExperienceDescription",
      defaultMessage: "Experience what machine learning, advanced security, and all our other {subscriptionFeaturesLinkText} have to offer.",
      values: {
        subscriptionFeaturesLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.SUBSCRIPTIONS,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 262,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.subscriptionFeaturesLinkText",
          defaultMessage: "subscription features",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 263,
            columnNumber: 17
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 9
      }
    }));
    const footer = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "startTrialButton",
      onClick: () => this.setState({
        showConfirmation: true
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.startTrialButtonLabel",
      defaultMessage: "Start trial",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_app_context.AppContextConsumer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 7
      }
    }, dependencies => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 11
      }
    }, this.acknowledgeModal(dependencies.docLinks), /*#__PURE__*/_react.default.createElement(_eui.EuiCard
    // @ts-ignore - Known issue from EUI, while they fix their types I've been told that we can just ignore this for now.
    , {
      hasBorder: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.startTrialTitle",
        defaultMessage: "Start a 30-day trial",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 17
        }
      }),
      description: description,
      footer: footer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 13
      }
    })));
  }
}
exports.StartTrial = StartTrial;