"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePageHeader = exports.ExpiredLicensePageHeader = exports.ActiveLicensePageHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _license_management = require("../../../store/reducers/license_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/license_management/public/application/sections/license_dashboard/license_page_header/license_page_header.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActiveLicensePageHeader = ({
  license,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, (0, _extends2.default)({}, props, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.activeLicenseStatusTitle",
      defaultMessage: "Your {licenseType} license is {status}",
      values: {
        licenseType: license.type,
        status: license.status
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseSubText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, license.expirationDate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.activeLicenseStatusDescription",
      defaultMessage: "Your license will expire on {licenseExpirationDate}",
      values: {
        licenseExpirationDate: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 40
          }
        }, license.expirationDate)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.permanentActiveLicenseStatusDescription",
      defaultMessage: "Your license will never expire.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }));
};
exports.ActiveLicensePageHeader = ActiveLicensePageHeader;
const ExpiredLicensePageHeader = ({
  license,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, (0, _extends2.default)({}, props, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.expiredLicenseStatusTitle",
      defaultMessage: "Your {licenseType} license has expired",
      values: {
        licenseType: license.type
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseSubText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.expiredLicenseStatusDescription",
      defaultMessage: "Your license expired on {licenseExpirationDate}",
      values: {
        licenseExpirationDate: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 38
          }
        }, license.expirationDate)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }));
};
exports.ExpiredLicensePageHeader = ExpiredLicensePageHeader;
const LicensePageHeader = () => {
  const license = (0, _reactRedux.useSelector)(_license_management.getLicenseState);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, license.isExpired ? /*#__PURE__*/_react.default.createElement(ExpiredLicensePageHeader, {
    license: license,
    bottomBorder: true,
    iconType: "warning",
    iconProps: {
      color: 'danger'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(ActiveLicensePageHeader, {
    license: license,
    bottomBorder: true,
    iconType: "checkInCircleFilled",
    iconProps: {
      color: 'success'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }));
};
exports.LicensePageHeader = LicensePageHeader;