"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensCMCreateResultSchema = exports.lensCMCreateOptionsSchema = exports.lensCMCreateBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _v = require("../../v0");
var _common = require("./common");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensCMCreateOptionsSchema = exports.lensCMCreateOptionsSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(_contentManagementUtils.createOptionsSchemas, ['overwrite', 'references'])
}, {
  unknowns: 'forbid'
});
const lensCMCreateBodySchema = exports.lensCMCreateBodySchema = _configSchema.schema.object({
  options: lensCMCreateOptionsSchema,
  data: _configSchema.schema.oneOf([_common.lensItemAttributesSchema, _v.lensItemAttributesSchemaV0 // Temporarily permit passing old v0 SO attributes on create
  ])
}, {
  unknowns: 'forbid'
});
const lensCMCreateResultSchema = exports.lensCMCreateResultSchema = (0, _contentManagementUtils.createResultSchema)(_common.lensSavedObjectSchema);