"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsLayerHeader = AnnotationsLayerHeader;
exports.LayerHeader = LayerHeader;
exports.LayerHeaderContent = LayerHeaderContent;
exports.ReferenceLayerHeader = ReferenceLayerHeader;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _chartIcons = require("@kbn/chart-icons");
var _react2 = require("@emotion/react");
var _data_view_picker_icon = require("../../../shared_components/ignore_global_filter/data_view_picker_icon");
var _state_helpers = require("../state_helpers");
var _shared_components = require("../../../shared_components");
var _visualization_helpers = require("../visualization_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/layer_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LayerHeader(props) {
  const layer = props.state.layers.find(l => l.layerId === props.layerId);
  if (!layer) {
    return null;
  }
  if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(ReferenceLayerHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(AnnotationsLayerHeader, {
      title: (0, _visualization_helpers.getAnnotationLayerTitle)(layer),
      hasUnsavedChanges: (0, _state_helpers.annotationLayerHasUnsavedChanges)(layer),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    });
  }
  return null;
}
function LayerHeaderContent(props) {
  const layer = props.state.layers.find(l => l.layerId === props.layerId);
  if (layer && (0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(AnnotationLayerHeaderContent, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 12
      }
    }));
  }
  return null;
}
function ReferenceLayerHeader() {
  return /*#__PURE__*/_react.default.createElement(_shared_components.StaticHeader, {
    icon: _chartIcons.IconChartBarReferenceLine,
    label: _i18n.i18n.translate('xpack.lens.xyChart.layerReferenceLineLabel', {
      defaultMessage: 'Reference lines'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
}
function AnnotationsLayerHeader({
  title,
  hasUnsavedChanges
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_shared_components.StaticHeader, {
    icon: _chartIcons.IconChartBarAnnotations,
    label: title || _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotationsLabel', {
      defaultMessage: 'Annotations'
    }),
    indicator: hasUnsavedChanges && /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
              padding-bottom: 3px;
              padding-left: 4px;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.lens.xyChart.unsavedChanges', {
        defaultMessage: 'Unsaved changes'
      }),
      type: "dot",
      color: euiTheme.colors.success,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  });
}
function AnnotationLayerHeaderContent({
  frame,
  state,
  layerId,
  onChangeIndexPattern
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const notFoundTitleLabel = _i18n.i18n.translate('xpack.lens.layerPanel.missingDataView', {
    defaultMessage: 'Data view not found'
  });
  const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[layerIndex];
  const currentIndexPattern = frame.dataViews.indexPatterns[layer.indexPatternId];
  return /*#__PURE__*/_react.default.createElement(_shared_components.ChangeIndexPattern, {
    "data-test-subj": "indexPattern-switcher",
    trigger: {
      label: (currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.name) || notFoundTitleLabel,
      title: (currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.title) || notFoundTitleLabel,
      'data-test-subj': 'lns_layerIndexPatternLabel',
      size: 's',
      fontWeight: 'normal',
      extraIcons: layer.ignoreGlobalFilters ? [(0, _data_view_picker_icon.getIgnoreGlobalFilterIcon)({
        color: euiTheme.colors.disabledText,
        dataTestSubj: 'lnsChangeIndexPatternIgnoringFilters'
      })] : undefined
    },
    indexPatternId: layer.indexPatternId,
    indexPatternRefs: frame.dataViews.indexPatternRefs,
    isMissingCurrent: !currentIndexPattern,
    onChangeIndexPattern: onChangeIndexPattern,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  });
}