"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPageFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _context = require("../../context");
var _ui_settings = require("../../ui_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_react/public/overview_page/overview_page_footer/overview_page_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const OverviewPageFooter = ({
  addBasePath,
  path,
  onSetDefaultRoute,
  onChangeDefaultRoute
}) => {
  const [defaultRoute, setDefaultRoute] = (0, _ui_settings.useUiSetting$)('defaultRoute');
  const {
    services: {
      application,
      notifications: {
        toasts
      }
    }
  } = (0, _context.useKibana)();
  const {
    show,
    save
  } = application.capabilities.advancedSettings;
  if (!show && !save) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const defaultRouteButton = defaultRoute.includes(path) ? /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "kbnOverviewPageFooter__button",
    flush: "both",
    iconType: "home",
    size: "s",
    onClick: event => {
      application.navigateToUrl(addBasePath('/app/management/kibana/settings?query=default+route'));
      if (onChangeDefaultRoute) {
        onChangeDefaultRoute(event);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibana-react.pageFooter.changeHomeRouteLink",
    defaultMessage: "Display a different page on log in",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "kbnOverviewPageFooter__button",
    flush: "both",
    iconType: "home",
    onClick: event => {
      setDefaultRoute(path);
      toasts.addSuccess({
        title: _i18n.i18n.translate('kibana-react.pageFooter.changeDefaultRouteSuccessToast', {
          defaultMessage: 'Landing page updated'
        })
      });
      if (onSetDefaultRoute) {
        onSetDefaultRoute(event);
      }
    },
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibana-react.pageFooter.makeDefaultRouteLink",
    defaultMessage: "Make this my landing page",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
  return (
    /*#__PURE__*/
    // Note: Using KibanaPageTemplate.Section instead of EuiPageTemplate causes Jest failures and bundle size issues
    _react.default.createElement(_eui.EuiPageTemplate.Section, {
      component: "footer",
      className: "kbnOverviewPageFooter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, defaultRouteButton))))
  );
};
exports.OverviewPageFooter = OverviewPageFooter;