"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/newsfeed-plugin/public");
var _app = require("./components/app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/kibana_overview/public/application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const renderApp = (core, deps, {
  appBasePath,
  element
}) => {
  const {
    notifications,
    http
  } = core;
  const {
    newsfeed,
    home,
    navigation
  } = deps;
  const newsfeed$ = newsfeed === null || newsfeed === void 0 ? void 0 : newsfeed.createNewsFeed$(_public2.NewsfeedApiEndpoint.KIBANA_ANALYTICS);
  const features$ = home.featureCatalogue.getFeatures$();
  core.chrome.setBreadcrumbs([{
    text: _i18n.i18n.translate('kibanaOverview.breadcrumbs.title', {
      defaultMessage: 'Analytics'
    })
  }]);
  core.chrome.navLinks.getNavLinks$().subscribe(navLinks => {
    const solutions = home.featureCatalogue.getSolutions().filter(({
      id
    }) => id !== 'kibana').filter(({
      id
    }) => navLinks.find(({
      category,
      visibleIn
    }) => visibleIn.includes('kibanaOverview') && (category === null || category === void 0 ? void 0 : category.id) === id));
    _reactDom.default.render(core.rendering.addContext(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...core,
        ...deps
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_app.KibanaOverviewApp, {
      basename: appBasePath,
      notifications,
      http,
      navigation,
      newsfeed$,
      solutions,
      features$,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }))), element);
  });
  return () => _reactDom.default.unmountComponentAtNode(element);
};
exports.renderApp = renderApp;