"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptDisplayManager = InterceptDisplayManager;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/intercepts/public/prompter/component/intercept_display_manager/intercept_display_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INTERCEPT_ILLUSTRATION_WIDTH = 89; // Magic number was provided by Ryan

const InterceptProgressIndicator = /*#__PURE__*/_react.default.memo(({
  stepsTotal,
  currentStep
}) => {
  if (!stepsTotal) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    className: "euiTourFooter__stepList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, [...Array(stepsTotal).keys()].map((_, i) => {
    let status = 'complete';
    if (currentStep === i) {
      status = 'active';
    } else if (currentStep <= i) {
      status = 'incomplete';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 20
      }
    });
  })));
});
function InterceptDisplayManager({
  ackIntercept,
  intercept$,
  staticAssetsHelper
}) {
  const interceptRenderMark = (0, _react.useRef)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [currentStepIndex, setCurrentStepIndex] = (0, _react.useState)(0);
  const [currentIntercept, setCurrentIntercept] = (0, _react.useState)(null);
  const feedbackStore = (0, _react.useRef)({});
  const startIllustrationStyle = (0, _react.useRef)((0, _react2.css)`
    background: var(
      --intercept-background,
      url(${staticAssetsHelper.getPluginAssetHref('communication.svg')})
    );
    background-size: ${INTERCEPT_ILLUSTRATION_WIDTH}px 64px;
    background-repeat: no-repeat;
    background-position: top ${euiTheme.size.base} right ${euiTheme.size.base};
  `);
  (0, _react.useEffect)(() => {
    const subscription = intercept$.subscribe(intercept => {
      setCurrentStepIndex(0);
      setCurrentIntercept(intercept);
      interceptRenderMark.current = performance.mark(`intercept-${intercept.id}-RenderMark`);
    });
    return () => subscription.unsubscribe();
  }, [intercept$]);
  const currentInterceptStep = (0, _react.useMemo)(() => {
    var _currentIntercept$ste;
    return currentIntercept === null || currentIntercept === void 0 ? void 0 : (_currentIntercept$ste = currentIntercept.steps) === null || _currentIntercept$ste === void 0 ? void 0 : _currentIntercept$ste[currentStepIndex];
  }, [currentIntercept, currentStepIndex]);
  const nextStep = (0, _react.useCallback)(isLastStep => {
    setCurrentStepIndex(prevStepIndex => {
      if (isLastStep) {
        var _currentIntercept$onF;
        currentIntercept === null || currentIntercept === void 0 ? void 0 : (_currentIntercept$onF = currentIntercept.onFinish) === null || _currentIntercept$onF === void 0 ? void 0 : _currentIntercept$onF.call(currentIntercept, {
          response: feedbackStore.current,
          runId: currentIntercept.runId
        });
        setCurrentStepIndex(0);
        // this will cause the component to unmount
        ackIntercept({
          runId: currentIntercept.runId,
          interceptId: currentIntercept.id,
          ackType: 'completed',
          interactionDuration: performance.measure('interceptCompleteMark', {
            start: interceptRenderMark.current.startTime,
            end: performance.now()
          }).duration
        });
      }
      return Math.min(prevStepIndex + 1, currentIntercept.steps.length);
    });
  }, [ackIntercept, currentIntercept]);
  const dismissProductIntercept = (0, _react.useCallback)(() => {
    var _currentIntercept$onD;
    const runId = currentIntercept.runId;
    ackIntercept({
      interceptId: currentIntercept.id,
      runId,
      ackType: 'dismissed',
      interactionDuration: performance.measure('interceptDismissedMark', {
        start: interceptRenderMark.current.startTime,
        end: performance.now()
      }).duration
    });
    currentIntercept === null || currentIntercept === void 0 ? void 0 : (_currentIntercept$onD = currentIntercept.onDismiss) === null || _currentIntercept$onD === void 0 ? void 0 : _currentIntercept$onD.call(currentIntercept, {
      runId,
      stepId: currentInterceptStep.id
    });
    setCurrentIntercept(null);
  }, [ackIntercept, currentIntercept, currentInterceptStep]);
  const onInputChange = (0, _react.useCallback)(value => {
    var _currentIntercept$onP;
    feedbackStore.current[currentInterceptStep.id] = value;
    currentIntercept === null || currentIntercept === void 0 ? void 0 : (_currentIntercept$onP = currentIntercept.onProgress) === null || _currentIntercept$onP === void 0 ? void 0 : _currentIntercept$onP.call(currentIntercept, {
      stepId: currentInterceptStep.id,
      stepResponse: value,
      runId: currentIntercept.runId
    });
    nextStep();
  }, [currentIntercept, currentInterceptStep, nextStep]);
  let isLastStep = false;
  const isStartStep = currentStepIndex === 0;
  return currentIntercept && currentInterceptStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    role: "dialog",
    css: (0, _react2.css)`
          position: fixed;
          inline-size: 400px;
          max-block-size: auto;
          z-index: ${euiTheme.levels.toast};
          inset-inline-end: ${euiTheme.size.l};
          inset-block-end: ${euiTheme.size.xxl};

          ${_eui.euiCanAnimate} {
            animation: ${_eui.euiFlyoutSlideInRight} ${euiTheme.animation.normal}
              ${euiTheme.animation.resistance};
          }
        `,
    "data-test-subj": `intercept-${currentIntercept.id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    css: (0, _react2.css)`
            min-height: 112px;
            position: relative;
            ${isStartStep && startIllustrationStyle.current};
          `,
    "data-test-subj": `interceptStep-${currentInterceptStep.id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    css: (0, _react2.css)({
      ...(isStartStep ? {
        width: `calc(100% - ${INTERCEPT_ILLUSTRATION_WIDTH}px - ${euiTheme.size.base})`
      } : {})
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }, currentInterceptStep.title))), currentStepIndex > 0 && !(isLastStep = currentStepIndex === currentIntercept.steps.length - 1) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": "Close dialog",
    onClick: dismissProductIntercept,
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(currentInterceptStep.content, {
    onValue: onInputChange
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    css: (0, _react2.css)`
            border-top: ${euiTheme.border.thin};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(InterceptProgressIndicator, {
    stepsTotal: currentIntercept.steps.length,
    currentStep: currentStepIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  })), (isStartStep || isLastStep) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }, isStartStep && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "data-test-subj": "productInterceptDismissButton",
    onClick: dismissProductIntercept,
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('core.notifications.productIntercept.dismiss', {
    defaultMessage: 'Not now'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "productInterceptProgressionButton",
    onClick: () => nextStep(isLastStep),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 21
    }
  }, isLastStep ? _i18n.i18n.translate('core.notifications.productIntercept.nextStep', {
    defaultMessage: 'Close'
  }) : _i18n.i18n.translate('core.notifications.productIntercept.nextStep', {
    defaultMessage: 'Next'
  }))))))))) : null;
}