"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSourceComponent = void 0;
var _utils = require("../utils");
var _get_fiber_type = require("./get_fiber_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Finds the {@link SourceComponent source component} for a {@link ReactFiberNode React Fiber node}.
 * @param {ReactFiberNode} fiber The {@link ReactFiberNode React Fiber node} to start the search from.
 * @return {SourceComponent | null} {@link SourceComponent Source component}, or null if it cannot be determined.
 */
const findSourceComponent = fiber => {
  var _fiber$element;
  let current = (_fiber$element = fiber.element) !== null && _fiber$element !== void 0 ? _fiber$element : null;
  let sourceComponent = null;
  while (current && !sourceComponent) {
    let fiberCursor = fiber;
    while (fiberCursor && !sourceComponent) {
      var _fiberCursor$_debugOw;
      const type = (0, _get_fiber_type.getFiberType)(fiberCursor);
      if (type) {
        if (!(0, _utils.isHtmlTag)(type) && !(0, _utils.isEui)(type) && !(0, _utils.isExcludedComponent)(type)) {
          sourceComponent = {
            element: current,
            type
          };
          break;
        }
      }
      fiberCursor = (_fiberCursor$_debugOw = fiberCursor._debugOwner) !== null && _fiberCursor$_debugOw !== void 0 ? _fiberCursor$_debugOw : fiberCursor.return;
    }
    current = current.parentElement;
  }
  return sourceComponent;
};
exports.findSourceComponent = findSourceComponent;