"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsiblePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_form/collapsible_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CollapsiblePanel = ({
  title,
  children,
  fieldName,
  toggleProps,
  accordionProps,
  initialToggleState
}) => {
  const form = (0, _shared_imports.useFormContext)();
  const [formData] = (0, _shared_imports.useFormData)({
    form
  });
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'collapsiblerPanel'
  });
  const [isEnabled, setIsEnabled] = (0, _react.useState)(initialToggleState);
  const [trigger, setTrigger] = (0, _react.useState)(isEnabled ? 'open' : 'closed');

  // We need to keep track of the initial field value for when the user
  // disable the enabled toggle (set field value to null) and then re-enable it.
  // In this scenario we want to show the initial value of the form.
  const [initialValue, setInitialValue] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (initialValue === undefined && formData[fieldName]) {
      setInitialValue(formData[fieldName]);
    }
  }, [formData, initialValue, fieldName]);
  const onToggleChange = e => {
    const isChecked = !!e.target.checked;
    setIsEnabled(isChecked);
    setTrigger(isChecked ? 'open' : 'closed');
    if (isChecked) {
      form.setFieldValue(fieldName, initialValue || '');
    } else {
      form.setFieldValue(fieldName, '');
    }
  };
  const onAccordionToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setTrigger(newState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({}, accordionProps, {
    id: accordionId,
    onToggle: onAccordionToggle,
    forceState: trigger,
    buttonContent: title,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, toggleProps, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.collapsiblePanelToggle",
        defaultMessage: "Enabled",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 15
        }
      }),
      checked: isEnabled,
      onChange: onToggleChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }), children({
    isEnabled
  })));
};
exports.CollapsiblePanel = CollapsiblePanel;