"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NginxLayoutSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _section = require("../section");
var _sub_section = require("../sub_section");
var _chart_section_vis = require("../chart_section_vis");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/layouts/nginx_layout_sections.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NginxLayoutSection = exports.NginxLayoutSection = (0, _eui.withEuiTheme)(({
  metrics,
  onChangeRangeTime,
  theme
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_section.Section, {
  navLabel: "Nginx",
  sectionLabel: "Nginx",
  metrics: metrics,
  onChangeRangeTime: onChangeRangeTime,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "nginxHits",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.nginxMetricsLayout.hitsSection.sectionLabel', {
    defaultMessage: 'Hits'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  stacked: true,
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    '200s': {
      color: theme.euiTheme.colors.vis.euiColorVis1
    },
    '300s': {
      color: theme.euiTheme.colors.vis.euiColorVis5
    },
    '400s': {
      color: theme.euiTheme.colors.vis.euiColorVis2
    },
    '500s': {
      color: theme.euiTheme.colors.vis.euiColorVis9
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "nginxRequestRate",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.nginxMetricsLayout.requestRateSection.sectionLabel', {
    defaultMessage: 'Request Rate'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "area",
  formatter: "abbreviatedNumber",
  formatterTemplate: "{{value}}/s",
  seriesOverrides: {
    rate: {
      color: theme.euiTheme.colors.vis.euiColorVis1
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "nginxActiveConnections",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.nginxMetricsLayout.activeConnectionsSection.sectionLabel', {
    defaultMessage: 'Active Connections'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "area",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    connections: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      type: 'bar'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "nginxRequestsPerConnection",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.nginxMetricsLayout.requestsPerConnectionsSection.sectionLabel', {
    defaultMessage: 'Requests per Connections'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    reqPerConns: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.nginxMetricsLayout.requestsPerConnectionsSection.reqsPerConnSeriesLabel', {
        defaultMessage: 'reqs per conn'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 11
  }
})))));