"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Node = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _conditional_tooltip = require("./conditional_tooltip");
var _color_from_value = require("../../lib/color_from_value");
var _node_context_menu = require("./node_context_menu");
var _node_square = require("./node_square");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/node.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Node = ({
  nodeType,
  node,
  options,
  squareSize,
  bounds,
  formatter,
  currentTime,
  setFlyoutUrlState,
  detailsItemId
}) => {
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const metric = (0, _lodash.first)(node.metrics);
  const rawValue = metric && metric.value || 0;
  const color = (0, _color_from_value.colorFromValue)(options.legend, rawValue, bounds);
  const value = formatter(rawValue);
  const isFlyoutMode = nodeType === 'host' || nodeType === 'container';
  const toggleAssetPopover = () => {
    if (isFlyoutMode) {
      setFlyoutUrlState({
        detailsItemId: node.id,
        entityType: nodeType
      });
    } else {
      togglePopover();
    }
  };
  const nodeSquare = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "regular",
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_conditional_tooltip.ConditionalToolTip, {
      currentTime: currentTime,
      node: node,
      nodeType: nodeType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 16
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "listitem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_node_square.NodeSquare, {
    squareSize: squareSize,
    togglePopover: toggleAssetPopover,
    color: color,
    nodeName: node.name,
    nodeMetric: metric ? metric.name : '',
    value: value,
    showBorder: detailsItemId === node.id || isPopoverOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
  return !isFlyoutMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: nodeSquare,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    zIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_node_context_menu.NodeContextMenu, {
    node: node,
    nodeType: nodeType,
    options: options,
    currentTime: currentTime,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  })) : nodeSquare;
};
exports.Node = Node;