"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialConfigurationStep = exports.InitialConfigurationStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _analysis_setup_indices_form = require("./analysis_setup_indices_form");
var _analysis_setup_timerange_form = require("./analysis_setup_timerange_form");
var _validation = require("./validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/initial_configuration_step/initial_configuration_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createInitialConfigurationStep = props => ({
  title: initialConfigurationStepTitle,
  children: /*#__PURE__*/_react.default.createElement(InitialConfigurationStep, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }))
});
exports.createInitialConfigurationStep = createInitialConfigurationStep;
const InitialConfigurationStep = ({
  setStartTime,
  setEndTime,
  startTime,
  endTime,
  isValidating,
  validatedIndices,
  setupStatus,
  setValidatedIndices,
  validationErrors = [],
  previousQualityWarnings = []
}) => {
  const disabled = (0, _react.useMemo)(() => !editableFormStatus.includes(setupStatus.type), [setupStatus]);
  const [indexValidationErrors, timeRangeValidationErrors, globalValidationErrors] = (0, _react.useMemo)(() => partitionValidationErrors(validationErrors), [validationErrors]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_analysis_setup_timerange_form.AnalysisSetupTimerangeForm, {
    disabled: disabled,
    setStartTime: setStartTime,
    setEndTime: setEndTime,
    startTime: startTime,
    endTime: endTime,
    validationErrors: timeRangeValidationErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_analysis_setup_indices_form.AnalysisSetupIndicesForm, {
    disabled: disabled,
    indices: validatedIndices,
    isValidating: isValidating,
    onChangeSelectedIndices: setValidatedIndices,
    previousQualityWarnings: previousQualityWarnings,
    validationErrors: indexValidationErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ValidationErrors, {
    errors: globalValidationErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })));
};
exports.InitialConfigurationStep = InitialConfigurationStep;
const editableFormStatus = ['required', 'failed', 'skipped'];
const errorCalloutTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.steps.initialConfigurationStep.errorCalloutTitle', {
  defaultMessage: 'Your index configuration is not valid'
});
const initialConfigurationStepTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.configurationStepTitle', {
  defaultMessage: 'Configuration'
});
const ValidationErrors = ({
  errors
}) => {
  if (errors.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: errorCalloutTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, errors.map((error, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, formatValidationError(error))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }));
};
const formatValidationError = error => {
  switch (error.error) {
    case 'NETWORK_ERROR':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.analysisSetup.indicesSelectionNetworkError",
        defaultMessage: "We couldn't load your index configuration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 9
        }
      });
    case 'TOO_FEW_SELECTED_INDICES':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.analysisSetup.indicesSelectionTooFewSelectedIndicesDescription",
        defaultMessage: "Select at least one index name.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 9
        }
      });
    default:
      return '';
  }
};
const partitionValidationErrors = validationErrors => validationErrors.reduce(([indicesErrors, timeRangeErrors, otherErrors], error) => {
  if (_validation.validationIndicesErrorRT.is(error)) {
    return [[...indicesErrors, error], timeRangeErrors, otherErrors];
  } else if (_validation.timeRangeValidationErrorRT.is(error)) {
    return [indicesErrors, [...timeRangeErrors, error], otherErrors];
  } else {
    return [indicesErrors, timeRangeErrors, [...otherErrors, error]];
  }
}, [[], [], []]);