"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _lodash = require("lodash");
var _chartsTheme = require("@kbn/charts-theme");
var _public = require("@kbn/logs-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _use_kibana = require("../../../../hooks/use_kibana");
var _log_threshold = require("../../../../../common/alerting/logs/log_threshold");
var _threshold = require("../../../common/components/threshold");
var _log_rate_analysis = require("./components/log_rate_analysis");
var _threhsold_chart = require("./components/threhsold_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/alert_details_app_section/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formatThreshold = threshold => String(threshold);
const AlertDetailsAppSection = ({
  rule,
  alert
}) => {
  var _application$capabili, _application$capabili2;
  const {
    services: {
      application
    }
  } = (0, _public2.useKibana)();
  const {
    logsShared
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  const interval = `${rule.params.timeSize}${rule.params.timeUnit}`;
  const thresholdFill = convertComparatorToFill(rule.params.count.comparator);
  const filter = rule.params.groupBy ? rule.params.groupBy.map(field => {
    const value = (0, _lodash.get)(alert.fields[_ruleDataUtils.ALERT_CONTEXT], ['groupByKeys', ...field.split('.')], null);
    return value ? `${field} : "${value}"` : null;
  }).filter(_lodash.identity).join(' AND ') : '';
  const {
    derivedDataView
  } = (0, _public.useLogView)({
    initialLogViewReference: rule.params.logView,
    logViews: logsShared.logViews.client
  });
  const aiopsEnabled = (_application$capabili = application === null || application === void 0 ? void 0 : (_application$capabili2 = application.capabilities.aiops) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.enabled) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const getLogRatioChart = () => {
    if ((0, _log_threshold.isRatioRule)(rule.params.criteria)) {
      var _alert$fields$ALERT_E;
      const numeratorKql = rule.params.criteria[0].map(criteria => convertCriteriaToKQL(criteria)).join(' AND ');
      const denominatorKql = rule.params.criteria[1].map(criteria => convertCriteriaToKQL(criteria)).join(' AND ');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: true,
        "data-test-subj": "logsRatioChartAlertDetails",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chart.ratioTitle', {
        defaultMessage: 'Ratio of QUERY A TO QUERY B'
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: {
          maxHeight: 120
        },
        grow: 1,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
        title: `Threshold breached`,
        chartProps: {
          baseTheme
        },
        comparator: _log_threshold.ComparatorToi18nSymbolsMap[rule.params.count.comparator],
        id: 'threshold-ratio-chart',
        thresholds: [rule.params.count.value],
        value: Number((_alert$fields$ALERT_E = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]) === null || _alert$fields$ALERT_E === void 0 ? void 0 : _alert$fields$ALERT_E.toFixed(2)),
        valueFormatter: formatThreshold,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 5,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 15
        }
      }), derivedDataView && /*#__PURE__*/_react.default.createElement(_threhsold_chart.LogThresholdRatioChart, {
        filter: filter,
        numeratorKql: numeratorKql,
        denominatorKql: denominatorKql,
        threshold: {
          value: rule.params.count.value,
          fill: thresholdFill
        },
        timeRange: timeRange,
        alertRange: {
          from: alert.start,
          to: alertEnd
        },
        index: {
          pattern: derivedDataView.getIndexPattern(),
          timestampField: derivedDataView.timeFieldName || '@timestamp'
        },
        height: 150,
        interval: interval,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 17
        }
      }))));
    } else return null;
  };
  const getLogCountChart = () => {
    if (!!rule.params.criteria && !(0, _log_threshold.isRatioRule)(rule.params.criteria)) {
      const kql = rule.params.criteria.map(criteria => convertCriteriaToKQL(criteria)).join(' AND ');
      const criteriaAsText = rule.params.criteria.map(criteria => {
        if (!criteria.field || !criteria.comparator || !criteria.value) {
          return '';
        }
        return `${criteria.field}  ${_log_threshold.ComparatorToi18nMap[criteria.comparator]} ${criteria.value}`;
      }).filter(text => text).join(' AND ');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: true,
        "data-test-subj": `logsCountChartAlertDetails`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chart.chartTitle', {
        defaultMessage: 'Logs for {criteria}',
        values: {
          criteria: criteriaAsText
        }
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: {
          maxHeight: 120
        },
        grow: 1,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
        title: `Threshold breached`,
        chartProps: {
          baseTheme
        },
        comparator: _log_threshold.ComparatorToi18nSymbolsMap[rule.params.count.comparator],
        id: "logCountThreshold",
        thresholds: [rule.params.count.value],
        value: Number(alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]),
        valueFormatter: formatThreshold,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 5,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 13
        }
      }, derivedDataView && /*#__PURE__*/_react.default.createElement(_threhsold_chart.LogThresholdCountChart, {
        filter: filter,
        kql: kql,
        threshold: {
          value: rule.params.count.value,
          fill: thresholdFill
        },
        timeRange: timeRange,
        alertRange: {
          from: alert.start,
          to: alertEnd
        },
        index: {
          pattern: derivedDataView.getIndexPattern(),
          timestampField: derivedDataView.timeFieldName || '@timestamp'
        },
        height: 150,
        interval: interval,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 17
        }
      }))));
    } else return null;
  };
  const getLogRateAnalysisSection = () => {
    return aiopsEnabled ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis.LogRateAnalysis, {
      rule: rule,
      alert: alert,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 27
      }
    }) : null;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "logsThresholdAlertDetailsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, getLogRatioChart(), getLogCountChart(), getLogRateAnalysisSection());
};
function convertComparatorToFill(comparator) {
  switch (comparator) {
    case _log_threshold.Comparator.GT:
    case _log_threshold.Comparator.GT_OR_EQ:
      return 'above';
    default:
      return 'below';
  }
}
function convertCriteriaToKQL(criteria) {
  if (!criteria.value || !criteria.comparator || !criteria.field) {
    return '';
  }
  switch (criteria.comparator) {
    case _log_threshold.Comparator.MATCH:
    case _log_threshold.Comparator.EQ:
      return `${criteria.field} : "${criteria.value}"`;
    case _log_threshold.Comparator.NOT_MATCH:
    case _log_threshold.Comparator.NOT_EQ:
      return `NOT ${criteria.field} : "${criteria.value}"`;
    case _log_threshold.Comparator.MATCH_PHRASE:
      return `${criteria.field} : ${criteria.value}`;
    case _log_threshold.Comparator.NOT_MATCH_PHRASE:
      return `NOT ${criteria.field} : ${criteria.value}`;
    case _log_threshold.Comparator.GT:
      return `${criteria.field} > ${criteria.value}`;
    case _log_threshold.Comparator.GT_OR_EQ:
      return `${criteria.field} >= ${criteria.value}`;
    case _log_threshold.Comparator.LT:
      return `${criteria.field} < ${criteria.value}`;
    case _log_threshold.Comparator.LT_OR_EQ:
      return `${criteria.field} <= ${criteria.value}`;
    default:
      return '';
  }
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AlertDetailsAppSection;
module.exports = exports.default;